/*
 * Decompiled with CFR 0.152.
 */
package io.github.discusser.tntarrows;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.discusser.tntarrows.TNTArrows;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import org.jetbrains.annotations.NotNull;

public class TNTArrowRecipe
extends CustomRecipe {
    public TNTArrowRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean isTntItem(ItemStack stack) {
        return stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof TntBlock;
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        List<ItemStack> items = recipeInput.items().stream().filter(itemStack -> !itemStack.is(Items.AIR)).toList();
        if (items.size() != 2) {
            return false;
        }
        boolean hasArrows = items.stream().anyMatch(itemStack -> itemStack.is(Items.ARROW));
        if (!hasArrows) {
            return false;
        }
        return items.stream().anyMatch(this::isTntItem);
    }

    @NotNull
    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        Optional<ItemStack> tntItem = recipeInput.items().stream().filter(this::isTntItem).findFirst();
        if (tntItem.isPresent()) {
            TntBlock tntBlock = (TntBlock)((BlockItem)tntItem.get().getItem()).getBlock();
            ItemStack result = new ItemStack(TNTArrows.TNT_ARROW);
            result.set((DataComponentType)TNTArrows.DATA_TNT_BLOCK.get(), (Object)tntBlock.arch$registryName());
            return result;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)TNTArrows.RECIPE_SERIALIZER_TNT_ARROW.get();
    }

    public static class Serializer
    implements RecipeSerializer<TNTArrowRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, TNTArrowRecipe> STREAM_CODEC;
        private static final MapCodec<TNTArrowRecipe> CODEC;

        @NotNull
        public MapCodec<TNTArrowRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TNTArrowRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category)).apply((Applicative)instance, TNTArrowRecipe::new));
            STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CustomRecipe::category, TNTArrowRecipe::new);
        }
    }
}

