/*
 * Decompiled with CFR 0.152.
 */
package de.mcreator.magicmod.network;

import de.mcreator.magicmod.MagicModMod;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MagicModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MagicModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.sec = message.data.sec;
                    variables.max_mana = message.data.max_mana;
                    variables.mana = message.data.mana;
                    variables.mana_bar_progrss_fill = message.data.mana_bar_progrss_fill;
                    variables.abilitys_stage = message.data.abilitys_stage;
                    variables.magic_class = message.data.magic_class;
                    variables.default_max_mana = message.data.default_max_mana;
                    variables.DelayedDeathEffectDamageCount = message.data.DelayedDeathEffectDamageCount;
                    variables.BankBallance = message.data.BankBallance;
                    variables.SniperIsScoping = message.data.SniperIsScoping;
                    variables.FireSpray = message.data.FireSpray;
                    variables.flight = message.data.flight;
                    variables.skill_xp = message.data.skill_xp;
                    variables.skill_level = message.data.skill_level;
                    variables.loop = message.data.loop;
                    variables.particleAmount = message.data.particleAmount;
                    variables.xRadius = message.data.xRadius;
                    variables.zRadius = message.data.zRadius;
                    variables.ParticleActive = message.data.ParticleActive;
                    variables.FireAwworStrenght = message.data.FireAwworStrenght;
                    variables.FireArrowHold = message.data.FireArrowHold;
                    variables.FireBallStrenght = message.data.FireBallStrenght;
                    variables.Soul_count = message.data.Soul_count;
                    variables.mob_count = message.data.mob_count;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double sec = 10.0;
        public double max_mana = 100.0;
        public double mana = 0.0;
        public double mana_bar_progrss_fill = 0.0;
        public double abilitys_stage = 0.0;
        public String magic_class = "none";
        public double default_max_mana = 100.0;
        public double DelayedDeathEffectDamageCount = 0.0;
        public double BankBallance = 0.0;
        public boolean SniperIsScoping = false;
        public boolean FireSpray = false;
        public boolean flight = false;
        public double skill_xp = 0.0;
        public double skill_level = 0.0;
        public double loop = 0.0;
        public double particleAmount = 0.0;
        public double xRadius = 0.0;
        public double zRadius = 0.0;
        public boolean ParticleActive = false;
        public double FireAwworStrenght = 0.0;
        public boolean FireArrowHold = false;
        public double FireBallStrenght = 0.0;
        public double Soul_count = 0.0;
        public double mob_count = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MagicModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("sec", this.sec);
            nbt.m_128347_("max_mana", this.max_mana);
            nbt.m_128347_("mana", this.mana);
            nbt.m_128347_("mana_bar_progrss_fill", this.mana_bar_progrss_fill);
            nbt.m_128347_("abilitys_stage", this.abilitys_stage);
            nbt.m_128359_("magic_class", this.magic_class);
            nbt.m_128347_("default_max_mana", this.default_max_mana);
            nbt.m_128347_("DelayedDeathEffectDamageCount", this.DelayedDeathEffectDamageCount);
            nbt.m_128347_("BankBallance", this.BankBallance);
            nbt.m_128379_("SniperIsScoping", this.SniperIsScoping);
            nbt.m_128379_("FireSpray", this.FireSpray);
            nbt.m_128379_("flight", this.flight);
            nbt.m_128347_("skill_xp", this.skill_xp);
            nbt.m_128347_("skill_level", this.skill_level);
            nbt.m_128347_("loop", this.loop);
            nbt.m_128347_("particleAmount", this.particleAmount);
            nbt.m_128347_("xRadius", this.xRadius);
            nbt.m_128347_("zRadius", this.zRadius);
            nbt.m_128379_("ParticleActive", this.ParticleActive);
            nbt.m_128347_("FireAwworStrenght", this.FireAwworStrenght);
            nbt.m_128379_("FireArrowHold", this.FireArrowHold);
            nbt.m_128347_("FireBallStrenght", this.FireBallStrenght);
            nbt.m_128347_("Soul_count", this.Soul_count);
            nbt.m_128347_("mob_count", this.mob_count);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.sec = nbt.m_128459_("sec");
            this.max_mana = nbt.m_128459_("max_mana");
            this.mana = nbt.m_128459_("mana");
            this.mana_bar_progrss_fill = nbt.m_128459_("mana_bar_progrss_fill");
            this.abilitys_stage = nbt.m_128459_("abilitys_stage");
            this.magic_class = nbt.m_128461_("magic_class");
            this.default_max_mana = nbt.m_128459_("default_max_mana");
            this.DelayedDeathEffectDamageCount = nbt.m_128459_("DelayedDeathEffectDamageCount");
            this.BankBallance = nbt.m_128459_("BankBallance");
            this.SniperIsScoping = nbt.m_128471_("SniperIsScoping");
            this.FireSpray = nbt.m_128471_("FireSpray");
            this.flight = nbt.m_128471_("flight");
            this.skill_xp = nbt.m_128459_("skill_xp");
            this.skill_level = nbt.m_128459_("skill_level");
            this.loop = nbt.m_128459_("loop");
            this.particleAmount = nbt.m_128459_("particleAmount");
            this.xRadius = nbt.m_128459_("xRadius");
            this.zRadius = nbt.m_128459_("zRadius");
            this.ParticleActive = nbt.m_128471_("ParticleActive");
            this.FireAwworStrenght = nbt.m_128459_("FireAwworStrenght");
            this.FireArrowHold = nbt.m_128471_("FireArrowHold");
            this.FireBallStrenght = nbt.m_128459_("FireBallStrenght");
            this.Soul_count = nbt.m_128459_("Soul_count");
            this.mob_count = nbt.m_128459_("mob_count");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("magic_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.sec = original.sec;
            clone.max_mana = original.max_mana;
            clone.mana = original.mana;
            clone.mana_bar_progrss_fill = original.mana_bar_progrss_fill;
            clone.abilitys_stage = original.abilitys_stage;
            clone.magic_class = original.magic_class;
            clone.default_max_mana = original.default_max_mana;
            clone.BankBallance = original.BankBallance;
            clone.skill_xp = original.skill_xp;
            clone.skill_level = original.skill_level;
            clone.Soul_count = original.Soul_count;
            if (!event.isWasDeath()) {
                clone.DelayedDeathEffectDamageCount = original.DelayedDeathEffectDamageCount;
                clone.SniperIsScoping = original.SniperIsScoping;
                clone.FireSpray = original.FireSpray;
                clone.flight = original.flight;
                clone.loop = original.loop;
                clone.particleAmount = original.particleAmount;
                clone.xRadius = original.xRadius;
                clone.zRadius = original.zRadius;
                clone.ParticleActive = original.ParticleActive;
                clone.FireAwworStrenght = original.FireAwworStrenght;
                clone.FireArrowHold = original.FireArrowHold;
                clone.FireBallStrenght = original.FireBallStrenght;
                clone.mob_count = original.mob_count;
            }
        }
    }
}

