/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon;

import io.myzticbean.finditemaddon.commands.simpapi.BuySubCmd;
import io.myzticbean.finditemaddon.commands.simpapi.DebugSubCmd;
import io.myzticbean.finditemaddon.commands.simpapi.HideShopSubCmd;
import io.myzticbean.finditemaddon.commands.simpapi.ReloadSubCmd;
import io.myzticbean.finditemaddon.commands.simpapi.RevealShopSubCmd;
import io.myzticbean.finditemaddon.commands.simpapi.SellSubCmd;
import io.myzticbean.finditemaddon.config.ConfigProvider;
import io.myzticbean.finditemaddon.config.ConfigSetup;
import io.myzticbean.finditemaddon.dependencies.BentoBoxPlugin;
import io.myzticbean.finditemaddon.dependencies.EssentialsXPlugin;
import io.myzticbean.finditemaddon.dependencies.PlayerWarpsPlugin;
import io.myzticbean.finditemaddon.dependencies.ResidencePlugin;
import io.myzticbean.finditemaddon.dependencies.WGPlugin;
import io.myzticbean.finditemaddon.handlers.gui.PlayerMenuUtility;
import io.myzticbean.finditemaddon.listeners.MenuListener;
import io.myzticbean.finditemaddon.listeners.PWPlayerWarpCreateEventListener;
import io.myzticbean.finditemaddon.listeners.PWPlayerWarpRemoveEventListener;
import io.myzticbean.finditemaddon.listeners.PlayerCommandSendEventListener;
import io.myzticbean.finditemaddon.listeners.PlayerJoinEventListener;
import io.myzticbean.finditemaddon.listeners.PluginEnableEventListener;
import io.myzticbean.finditemaddon.listeners.ShopCreateEventListener;
import io.myzticbean.finditemaddon.listeners.ShopDeleteEventListener;
import io.myzticbean.finditemaddon.metrics.Metrics;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.quickshop.QSApi;
import io.myzticbean.finditemaddon.quickshop.impl.QSHikariAPIHandler;
import io.myzticbean.finditemaddon.quickshop.impl.QSReremakeAPIHandler;
import io.myzticbean.finditemaddon.scheduledtasks.Task15MinInterval;
import io.myzticbean.finditemaddon.utils.UpdateChecker;
import io.myzticbean.finditemaddon.utils.async.VirtualThreadScheduler;
import io.myzticbean.finditemaddon.utils.json.ShopSearchActivityStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import me.kodysimpson.simpapi.command.CommandManager;
import me.kodysimpson.simpapi.command.SubCommand;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.LoggerFactory;

public final class FindItemAddOn
extends JavaPlugin {
    @Generated
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(FindItemAddOn.class);
    private static final boolean ENABLE_TRIAL_PERIOD = false;
    private static final int TRIAL_END_YEAR = 2024;
    private static final int TRIAL_END_MONTH = 5;
    private static final int TRIAL_END_DAY = 5;
    private static Plugin pluginInstance;
    public static String serverVersion;
    private static final int BS_PLUGIN_METRIC_ID = 12382;
    private static final int SPIGOT_PLUGIN_ID = 95104;
    private static final String MODRINTH_PROJECT_SLUG = "asp13ugE";
    private static final int REPEATING_TASK_SCHEDULE_MINS = 18000;
    private static ConfigProvider configProvider;
    private static UpdateChecker updateChecker;
    private static boolean isPluginOutdated;
    private static boolean qSReremakeInstalled;
    private static boolean qSHikariInstalled;
    private static QSApi<?, ?> qsApi;
    private static BentoBoxPlugin bentoboxPlugin;
    private static final HashMap<Player, PlayerMenuUtility> playerMenuUtilityMap;

    public FindItemAddOn() {
        pluginInstance = this;
    }

    public static Plugin getInstance() {
        return pluginInstance;
    }

    public void onLoad() {
        Logger.logInfo("A Shop Search AddOn for QuickShop developed by myzticbean");
        if (this.getDescription().getVersion().toLowerCase().contains("snapshot")) {
            Logger.logWarning("This is a SNAPSHOT build! NOT recommended for production servers.");
            Logger.logWarning("If you find any bugs, please report them here: https://github.com/myzticbean/QSFindItemAddOn/issues");
        }
    }

    public void onEnable() {
        if (!Bukkit.getPluginManager().isPluginEnabled("QuickShop") && !Bukkit.getPluginManager().isPluginEnabled("QuickShop-Hikari")) {
            Logger.logInfo("Delaying QuickShop hook as they are not enabled yet");
        } else if (Bukkit.getPluginManager().isPluginEnabled("QuickShop")) {
            qSReremakeInstalled = true;
        } else {
            qSHikariInstalled = true;
        }
        this.initBukkitEventListeners();
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        ConfigSetup.setupConfig();
        ConfigSetup.get().options().copyDefaults(true);
        ConfigSetup.checkForMissingProperties();
        ConfigSetup.saveConfig();
        FindItemAddOn.initConfigProvider();
        ConfigSetup.copySampleConfig();
        this.initCommands();
        Bukkit.getScheduler().scheduleSyncDelayedTask(FindItemAddOn.getInstance(), this::runPluginStartupTasks);
    }

    public void onDisable() {
        if (qsApi != null) {
            ShopSearchActivityStorageUtil.saveShopsToFile();
        } else {
            Logger.logError("Uh oh! Looks like either this plugin has crashed or you don't have QuickShop-Hikari or QuickShop-Reremake installed.");
        }
        VirtualThreadScheduler.shutdown();
        Logger.logInfo("Bye!");
    }

    private void runPluginStartupTasks() {
        serverVersion = Bukkit.getServer().getVersion();
        Logger.logInfo("Server version found: " + serverVersion);
        if (!FindItemAddOn.isQSReremakeInstalled() && !FindItemAddOn.isQSHikariInstalled()) {
            Logger.logError("QuickShop-Hikari is required to use this addon. Please install QuickShop and try again!");
            Logger.logError("Download link:");
            Logger.logError("\u00bb QuickShop-Hikari: https://www.spigotmc.org/resources/100125");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (FindItemAddOn.isQSReremakeInstalled()) {
            Logger.logInfo("Found QuickShop-Reremake");
            qsApi = new QSReremakeAPIHandler();
            qsApi.registerSubCommand();
        } else {
            Logger.logInfo("Found QuickShop-Hikari");
            qsApi = new QSHikariAPIHandler();
            qsApi.registerSubCommand();
        }
        ShopSearchActivityStorageUtil.loadShopsFromFile();
        ShopSearchActivityStorageUtil.migrateHiddenShopsToShopsJson();
        PlayerWarpsPlugin.setup();
        EssentialsXPlugin.setup();
        WGPlugin.setup();
        ResidencePlugin.setup();
        bentoboxPlugin = new BentoBoxPlugin();
        this.initExternalPluginEventListeners();
        Logger.logInfo("Registering tasks");
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new Task15MinInterval(), 0L, 18000L);
        Logger.logInfo("Registering anonymous bStats metrics");
        new Metrics(this, 12382);
        this.checkForPluginUpdates();
    }

    private void checkForPluginUpdates() {
        updateChecker = new UpdateChecker();
        updateChecker.isUpdateAvailable(isUpdateAvailable -> {
            if (Boolean.TRUE.equals(isUpdateAvailable)) {
                isPluginOutdated = true;
            }
        });
    }

    private void initCommands() {
        Logger.logInfo("Registering commands");
        this.initFindItemCmd();
        this.initFindItemAdminCmd();
    }

    private void initBukkitEventListeners() {
        Logger.logInfo("Registering Bukkit event listeners");
        this.getServer().getPluginManager().registerEvents((Listener)new PluginEnableEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerCommandSendEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopCreateEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ShopDeleteEventListener(), (Plugin)this);
    }

    private void initExternalPluginEventListeners() {
        Logger.logInfo("Registering external plugin event listeners");
        if (PlayerWarpsPlugin.getIsEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new PWPlayerWarpRemoveEventListener(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PWPlayerWarpCreateEventListener(), (Plugin)this);
        }
    }

    public static void initConfigProvider() {
        configProvider = new ConfigProvider();
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player p) {
        if (playerMenuUtilityMap.containsKey(p)) {
            return playerMenuUtilityMap.get(p);
        }
        PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(p);
        playerMenuUtilityMap.put(p, playerMenuUtility);
        return playerMenuUtility;
    }

    public static int getPluginID() {
        return 95104;
    }

    public static String getModrinthProjectSlug() {
        return MODRINTH_PROJECT_SLUG;
    }

    private void initFindItemCmd() {
        List<String> aliases = StringUtils.isEmpty(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE) || StringUtils.containsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE, " ") ? Arrays.asList("shopsearch", "searchshop", "searchitem") : FindItemAddOn.getConfigProvider().FIND_ITEM_COMMAND_ALIAS;
        Class[] subCommands = FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_REMOVE_HIDE_REVEAL_SUBCMDS ? new Class[]{SellSubCmd.class, BuySubCmd.class} : new Class[]{SellSubCmd.class, BuySubCmd.class, HideShopSubCmd.class, RevealShopSubCmd.class};
        try {
            CommandManager.createCoreCommand((JavaPlugin)this, "finditem", "Search for items from all shops using an interactive GUI", "/finditem", (commandSender, subCommandList) -> {
                commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
                commandSender.sendMessage(ColorTranslator.translateColorCodes("&7------------------------"));
                commandSender.sendMessage(ColorTranslator.translateColorCodes("&6&lShop Search Commands"));
                commandSender.sendMessage(ColorTranslator.translateColorCodes("&7------------------------"));
                for (SubCommand subCommand : subCommandList) {
                    commandSender.sendMessage(ColorTranslator.translateColorCodes("&#ff9933" + subCommand.getSyntax() + " &#a3a3c2" + subCommand.getDescription()));
                }
                commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
                commandSender.sendMessage(ColorTranslator.translateColorCodes("&#b3b300Command aliases:"));
                aliases.forEach(alias -> commandSender.sendMessage(ColorTranslator.translateColorCodes("&8&l\u00bb &#2db300/" + alias)));
                commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
            }, aliases, subCommands);
            Logger.logInfo("Registered /finditem command");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.logError(e);
        }
    }

    private void initFindItemAdminCmd() {
        List<String> alias = List.of("fiadmin");
        try {
            CommandManager.createCoreCommand((JavaPlugin)this, "finditemadmin", "Admin command for Shop Search addon", "/finditemadmin", (commandSender, subCommandList) -> {
                if (commandSender.isOp() || !commandSender.isOp() && (commandSender.hasPermission(PlayerPermsEnum.FINDITEM_ADMIN.value()) || commandSender.hasPermission(PlayerPermsEnum.FINDITEM_RELOAD.value()))) {
                    commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
                    commandSender.sendMessage(ColorTranslator.translateColorCodes("&7-----------------------------"));
                    commandSender.sendMessage(ColorTranslator.translateColorCodes("&6&lShop Search Admin Commands"));
                    commandSender.sendMessage(ColorTranslator.translateColorCodes("&7-----------------------------"));
                    for (SubCommand subCommand : subCommandList) {
                        commandSender.sendMessage(ColorTranslator.translateColorCodes("&#ff1a1a" + subCommand.getSyntax() + " &#a3a3c2" + subCommand.getDescription()));
                    }
                    commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
                    commandSender.sendMessage(ColorTranslator.translateColorCodes("&#b3b300Command alias:"));
                    alias.forEach(alias_i -> commandSender.sendMessage(ColorTranslator.translateColorCodes("&8&l\u00bb &#2db300/" + alias_i)));
                    commandSender.sendMessage(ColorTranslator.translateColorCodes(""));
                }
            }, alias, ReloadSubCmd.class, DebugSubCmd.class);
            Logger.logInfo("Registered /finditemadmin command");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.logError(e);
        }
    }

    public static void setQSReremakeInstalled(boolean qSReremakeInstalled) {
        FindItemAddOn.qSReremakeInstalled = qSReremakeInstalled;
    }

    public static void setQSHikariInstalled(boolean qSHikariInstalled) {
        FindItemAddOn.qSHikariInstalled = qSHikariInstalled;
    }

    public static QSApi<?, ?> getQsApiInstance() {
        return qsApi;
    }

    @Generated
    public static ConfigProvider getConfigProvider() {
        return configProvider;
    }

    @Generated
    public static UpdateChecker getUpdateChecker() {
        return updateChecker;
    }

    @Generated
    public static boolean isPluginOutdated() {
        return isPluginOutdated;
    }

    @Generated
    public static boolean isQSReremakeInstalled() {
        return qSReremakeInstalled;
    }

    @Generated
    public static boolean isQSHikariInstalled() {
        return qSHikariInstalled;
    }

    @Generated
    public static BentoBoxPlugin getBentoboxPlugin() {
        return bentoboxPlugin;
    }

    static {
        isPluginOutdated = false;
        qSReremakeInstalled = false;
        qSHikariInstalled = false;
        playerMenuUtilityMap = new HashMap();
    }
}

