/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.commands.quickshop.subcommands;

import com.ghostchu.quickshop.api.command.CommandHandler;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.handlers.command.CmdExecutorHandler;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import java.util.ArrayList;
import java.util.List;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindItemCmdHikariImpl
implements CommandHandler<Player> {
    private final String hideSubCommand;
    private final String revealShopSubCommand;
    private final CmdExecutorHandler cmdExecutor;
    private final List<String> itemsList = new ArrayList<String>();
    private final List<String> buyOrSellList = new ArrayList<String>();

    public FindItemCmdHikariImpl() {
        if (FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_REMOVE_HIDE_REVEAL_SUBCMDS) {
            // empty if block
        }
        this.hideSubCommand = StringUtils.isBlank(FindItemAddOn.getConfigProvider().FIND_ITEM_HIDESHOP_AUTOCOMPLETE) ? "hideshop" : FindItemAddOn.getConfigProvider().FIND_ITEM_HIDESHOP_AUTOCOMPLETE;
        this.revealShopSubCommand = StringUtils.isEmpty(FindItemAddOn.getConfigProvider().FIND_ITEM_REVEALSHOP_AUTOCOMPLETE) || StringUtils.containsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_REVEALSHOP_AUTOCOMPLETE, " ") ? "revealshop" : FindItemAddOn.getConfigProvider().FIND_ITEM_REVEALSHOP_AUTOCOMPLETE;
        this.cmdExecutor = new CmdExecutorHandler();
    }

    public void onCommand(Player commandSender, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            commandSender.sendMessage(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().PLUGIN_PREFIX + "&cIncorrect usage!"));
        } else if (args.length == 1) {
            if (commandSender.hasPermission(PlayerPermsEnum.FINDITEM_HIDESHOP.value()) && !FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_REMOVE_HIDE_REVEAL_SUBCMDS) {
                if (args[0].equalsIgnoreCase(this.hideSubCommand)) {
                    this.cmdExecutor.handleHideShop((CommandSender)commandSender);
                } else if (args[0].equalsIgnoreCase(this.revealShopSubCommand)) {
                    this.cmdExecutor.handleRevealShop((CommandSender)commandSender);
                } else {
                    commandSender.sendMessage(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().PLUGIN_PREFIX + "&cIncorrect usage!"));
                }
            } else {
                commandSender.sendMessage(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().PLUGIN_PREFIX + "&cYou don't have permission to use that!"));
            }
        } else {
            this.cmdExecutor.handleShopSearch(args[0], (CommandSender)commandSender, args[1]);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (this.itemsList.isEmpty()) {
            for (Material mat : Material.values()) {
                this.itemsList.add(mat.name());
            }
        }
        if (this.buyOrSellList.isEmpty()) {
            if (StringUtils.isEmpty(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE) || StringUtils.containsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE, " ")) {
                this.buyOrSellList.add("TO_BUY");
            } else {
                this.buyOrSellList.add(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE);
            }
            if (StringUtils.isEmpty(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE) || StringUtils.containsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE, " ")) {
                this.buyOrSellList.add("TO_SELL");
            } else {
                this.buyOrSellList.add(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE);
            }
            if (sender.hasPermission(PlayerPermsEnum.FINDITEM_HIDESHOP.value()) && !FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_REMOVE_HIDE_REVEAL_SUBCMDS) {
                this.buyOrSellList.add(FindItemAddOn.getConfigProvider().FIND_ITEM_HIDESHOP_AUTOCOMPLETE);
                this.buyOrSellList.add(FindItemAddOn.getConfigProvider().FIND_ITEM_REVEALSHOP_AUTOCOMPLETE);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (args.length == 1) {
            for (String a : this.buyOrSellList) {
                if (!a.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                result.add(a);
            }
            return result;
        }
        if (args.length == 2) {
            for (String a : this.itemsList) {
                if (!a.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                result.add(a);
            }
            return result;
        }
        return null;
    }
}

