/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.commands.simpapi;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.handlers.command.CmdExecutorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import me.kodysimpson.simpapi.command.SubCommand;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SellSubCmd
extends SubCommand {
    private final String sellSubCommand;
    private final List<String> itemsList = new ArrayList<String>();
    private final CmdExecutorHandler cmdExecutor;

    public SellSubCmd() {
        this.sellSubCommand = StringUtils.isBlank(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE) ? "TO_SELL" : FindItemAddOn.getConfigProvider().FIND_ITEM_TO_SELL_AUTOCOMPLETE;
        if (this.itemsList.isEmpty()) {
            this.itemsList.addAll(Arrays.stream(Material.values()).filter(mat -> !FindItemAddOn.getConfigProvider().getBlacklistedMaterials().contains(mat)).map(Enum::name).toList());
        }
        this.cmdExecutor = new CmdExecutorHandler();
    }

    @Override
    public String getName() {
        return this.sellSubCommand;
    }

    @Override
    public List<String> getAliases() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Find shops that sell a specific item";
    }

    @Override
    public String getSyntax() {
        return "/finditem " + this.sellSubCommand + " {item type | item name}";
    }

    @Override
    public void perform(CommandSender commandSender, String[] args) {
        if (args.length != 2) {
            commandSender.sendMessage(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().PLUGIN_PREFIX + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INCORRECT_USAGE_MSG));
        } else {
            this.cmdExecutor.handleShopSearch(this.sellSubCommand, commandSender, args[1]);
        }
    }

    @Override
    public List<String> getSubcommandArguments(Player player, String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        for (String a : this.itemsList) {
            if (!a.toLowerCase().startsWith(args[1].toLowerCase())) continue;
            result.add(a);
        }
        return result;
    }
}

