/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.config;

import io.myzticbean.finditemaddon.config.ConfigSetup;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.ArrayList;
import java.util.List;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;

public class ConfigProvider {
    private static final String FIND_ITEM_COMMAND = "find-item-command.";
    private static final String PLAYER_SHOP_TELEPORTATION = "player-shop-teleportation.";
    private static final String DIRECT_SHOP_TP_MODE = "direct-shop-tp-mode.";
    private static final String NEAREST_WARP_TP_MODE = "nearest-warp-tp-mode.";
    private static final String CUSTOM_COMMANDS = "custom-commands.";
    private static final String SHOP_GUI = "shop-gui.";
    private static final String SHOP_GUI_NAVIGATION = "shop-navigation.";
    private static final String SHOP_GUI_CMD = "custom-model-data.";
    private static final String BENTOBOX = "bentobox.";
    public final String PLUGIN_PREFIX = ColorTranslator.translateColorCodes(ConfigSetup.get().getString("plugin-prefix"));
    public final List<String> FIND_ITEM_COMMAND_ALIAS = ConfigSetup.get().getList("find-item-command.command-alias");
    public final String FIND_ITEM_TO_BUY_AUTOCOMPLETE = ConfigSetup.get().getString("find-item-command.to-buy-autocomplete");
    public final String FIND_ITEM_TO_SELL_AUTOCOMPLETE = ConfigSetup.get().getString("find-item-command.to-sell-autocomplete");
    public final String FIND_ITEM_HIDESHOP_AUTOCOMPLETE = ConfigSetup.get().getString("find-item-command.hideshop-autocomplete");
    public final String FIND_ITEM_REVEALSHOP_AUTOCOMPLETE = ConfigSetup.get().getString("find-item-command.revealshop-autocomplete");
    public final String FIND_ITEM_CMD_INCORRECT_USAGE_MSG = ConfigSetup.get().getString("find-item-command.incorrect-usage-message");
    public final String FIND_ITEM_CMD_INVALID_MATERIAL_MSG = ConfigSetup.get().getString("find-item-command.invalid-material-message");
    public final String SHOP_SEARCH_LOADING_MSG = ConfigSetup.get().getString("find-item-command.shop-search-loading-message");
    public final String NO_SHOP_FOUND_MSG = ConfigSetup.get().getString("find-item-command.no-shop-found-message");
    public final String FIND_ITEM_CMD_NO_PERMISSION_MSG = ConfigSetup.get().getString("find-item-command.find-item-command-no-permission-message");
    public final String FIND_ITEM_CMD_SHOP_HIDE_SUCCESS_MSG = ConfigSetup.get().getString("find-item-command.shop-hide-success-message");
    public final String FIND_ITEM_CMD_SHOP_REVEAL_SUCCESS_MSG = ConfigSetup.get().getString("find-item-command.shop-reveal-success-message");
    public final String FIND_ITEM_CMD_SHOP_ALREADY_HIDDEN_MSG = ConfigSetup.get().getString("find-item-command.shop-already-hidden-message");
    public final String FIND_ITEM_CMD_SHOP_ALREADY_PUBLIC_MSG = ConfigSetup.get().getString("find-item-command.shop-already-public-message");
    public final String FIND_ITEM_CMD_INVALID_SHOP_BLOCK_MSG = ConfigSetup.get().getString("find-item-command.invalid-shop-block-message");
    public final String FIND_ITEM_CMD_HIDING_SHOP_OWNER_INVALID_MSG = ConfigSetup.get().getString("find-item-command.hiding-shop-owner-invalid-message");
    public final boolean FIND_ITEM_CMD_REMOVE_HIDE_REVEAL_SUBCMDS = ConfigSetup.get().getBoolean("find-item-command.remove-hideshop-revealshop-subcommands");
    public final boolean FIND_ITEM_CMD_DISABLE_SEARCH_ALL_SHOPS = ConfigSetup.get().getBoolean("find-item-command.disable-search-all-shops");
    public final int SHOP_SORTING_METHOD = ConfigSetup.get().getInt("shop-sorting-method");
    public final boolean SEARCH_LOADED_SHOPS_ONLY = ConfigSetup.get().getBoolean("search-loaded-shops-only");
    public final String SHOP_SEARCH_GUI_TITLE = ConfigSetup.get().getString("shop-search-gui-title");
    public final int NEAREST_WARP_MODE = ConfigSetup.get().getInt("nearest-warp-mode");
    public final List<String> SHOP_GUI_ITEM_LORE = ConfigSetup.get().getList("shop-gui-item-lore");
    public final boolean TP_PLAYER_DIRECTLY_TO_SHOP = ConfigSetup.get().getBoolean("player-shop-teleportation.direct-shop-tp-mode.tp-player-directly-to-shop");
    public final String CLICK_TO_TELEPORT_MSG = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.click-to-teleport-message");
    public final String SHOP_TP_NO_PERMISSION_MSG = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.shop-tp-no-permission-message");
    public final String UNSAFE_SHOP_AREA_MSG = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.unsafe-shop-area-message");
    public final String TP_DELAY_IN_SECONDS = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.tp-delay-in-seconds");
    public final String TP_DELAY_MESSAGE = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.tp-delay-message");
    public final String TP_TO_OWN_SHOP_NO_PERMISSION_MESSAGE = ConfigSetup.get().getString("player-shop-teleportation.direct-shop-tp-mode.tp-to-own-shop-no-permission-message");
    public final boolean TP_PLAYER_TO_NEAREST_WARP = ConfigSetup.get().getBoolean("player-shop-teleportation.nearest-warp-tp-mode.tp-player-to-nearest-warp");
    public final boolean DO_NOT_TP_IF_PLAYER_WARP_LOCKED = ConfigSetup.get().getBoolean("player-shop-teleportation.nearest-warp-tp-mode.do-not-tp-if-warp-locked");
    public final boolean ONLY_SHOW_PLAYER_OWNDED_WARPS = ConfigSetup.get().getBoolean("player-shop-teleportation.nearest-warp-tp-mode.only-show-player-owned-warps");
    public final boolean USE_RESIDENCE_SUBZONES = ConfigSetup.get().getBoolean("player-shop-teleportation.nearest-warp-tp-mode.use-residence-subzones");
    public final String NO_WARP_NEAR_SHOP_ERROR_MSG = ConfigSetup.get().getString("player-shop-teleportation.nearest-warp-tp-mode.no-warp-near-shop-error-message");
    public final String NO_WG_REGION_NEAR_SHOP_ERROR_MSG = ConfigSetup.get().getString("player-shop-teleportation.nearest-warp-tp-mode.no-wg-region-near-shop-error-message");
    public final String NO_RESIDENCE_NEAR_SHOP_ERROR_MSG = ConfigSetup.get().getString("player-shop-teleportation.nearest-warp-tp-mode.no-residence-near-shop-error-message");
    public final boolean CUSTOM_CMDS_RUN_ENABLED = ConfigSetup.get().getBoolean("player-shop-teleportation.custom-commands.run-custom-commands");
    public final List<String> CUSTOM_CMDS_LIST = ConfigSetup.get().getList("player-shop-teleportation.custom-commands.commands-list");
    public final String SHOP_GUI_BACK_BUTTON_MATERIAL = ConfigSetup.get().getString("shop-gui.back-button-material");
    public final String SHOP_GUI_BACK_BUTTON_TEXT = ConfigSetup.get().getString("shop-gui.back-button-text");
    public final String SHOP_GUI_NEXT_BUTTON_MATERIAL = ConfigSetup.get().getString("shop-gui.next-button-material");
    public final String SHOP_GUI_NEXT_BUTTON_TEXT = ConfigSetup.get().getString("shop-gui.next-button-text");
    public final String SHOP_GUI_FILLER_ITEM = ConfigSetup.get().getString("shop-gui.filler-item");
    public final String SHOP_GUI_CLOSE_BUTTON_MATERIAL = ConfigSetup.get().getString("shop-gui.close-button-material");
    public final String SHOP_GUI_CLOSE_BUTTON_TEXT = ConfigSetup.get().getString("shop-gui.close-button-text");
    public final String SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_MATERIAL = ConfigSetup.get().getString("shop-gui.goto-first-page-button-material");
    public final String SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_TEXT = ConfigSetup.get().getString("shop-gui.goto-first-page-button-text");
    public final String SHOP_GUI_GOTO_LAST_PAGE_BUTTON_MATERIAL = ConfigSetup.get().getString("shop-gui.goto-last-page-button-material");
    public final String SHOP_GUI_GOTO_LAST_PAGE_BUTTON_TEXT = ConfigSetup.get().getString("shop-gui.goto-last-page-button-text");
    public final String SHOP_GUI_BACK_BUTTON_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.back-button-custom-model-data");
    public final String SHOP_GUI_NEXT_BUTTON_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.next-button-custom-model-data");
    public final String SHOP_GUI_CLOSE_BUTTON_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.close-button-custom-model-data");
    public final String SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.goto-first-page-button-custom-model-data");
    public final String SHOP_GUI_GOTO_LAST_PAGE_BUTTON_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.goto-last-page-button-custom-model-data");
    public final String SHOP_GUI_FILLER_ITEM_CMD = ConfigSetup.get().getString("shop-gui.custom-model-data.filler-item-custom-model-data");
    public final String SHOP_NAV_FIRST_PAGE_ALERT_MSG = ConfigSetup.get().getString("shop-gui.shop-navigation.first-page-alert-message");
    public final String SHOP_NAV_LAST_PAGE_ALERT_MSG = ConfigSetup.get().getString("shop-gui.shop-navigation.last-page-alert-message");
    public final boolean SHOP_GUI_USE_SHORTER_CURRENCY_FORMAT = ConfigSetup.get().getBoolean("shop-gui.use-shorter-currency-format");
    public final int SHOP_PLAYER_VISIT_COOLDOWN_IN_MINUTES = ConfigSetup.get().getInt("shop-player-visit-cooldown-in-minutes");
    public final boolean IGNORE_EMPTY_CHESTS = ConfigSetup.get().getBoolean("ignore-empty-chests");
    private final List<String> BLACKLISTED_WORLDS = ConfigSetup.get().getList("blacklisted-worlds");
    private final List<String> BLACKLISTED_MATERIALS = ConfigSetup.get().getList("blacklisted-materials");
    public final boolean SUPPRESS_UPDATE_NOTIFICATIONS = ConfigSetup.get().getBoolean("suppress-update-notifications");
    public final int CONFIG_VERSION = ConfigSetup.get().getInt("config-version");
    public final boolean BENTOBOX_IGNORE_LOCKED_ISLAND_SHOPS = ConfigSetup.get().getBoolean("bentobox.ignore-locked-island-shops");
    private boolean debugMode = ConfigSetup.get().getBoolean("debug-mode");
    private final List<World> blacklistedWorldsList = new ArrayList<World>();
    private final List<Material> blacklistedMaterialsList = new ArrayList<Material>();

    public ConfigProvider() {
        this.loadBlacklistedWorlds();
        this.loadBlacklistedMaterials();
        Logger.logInfo("Config loaded!");
    }

    public boolean isDebugModeEnabled() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        ConfigSetup.get().set("debug-mode", (Object)debugMode);
        ConfigSetup.get().set("config-version", (Object)ConfigSetup.getCURRENT_CONFIG_VERSION());
        ConfigSetup.saveConfig();
    }

    public List<World> getBlacklistedWorlds() {
        return this.blacklistedWorldsList;
    }

    public List<Material> getBlacklistedMaterials() {
        return this.blacklistedMaterialsList;
    }

    public boolean shopGUIItemLoreHasKey(String key) {
        if (this.SHOP_GUI_ITEM_LORE != null) {
            return this.SHOP_GUI_ITEM_LORE.stream().anyMatch(key::contains);
        }
        return false;
    }

    private void loadBlacklistedWorlds() {
        if (this.BLACKLISTED_WORLDS != null) {
            this.BLACKLISTED_WORLDS.forEach(world -> {
                World worldObj = Bukkit.getWorld((String)world);
                if (worldObj != null) {
                    this.blacklistedWorldsList.add(worldObj);
                }
            });
        }
    }

    private void loadBlacklistedMaterials() {
        if (this.BLACKLISTED_MATERIALS != null) {
            this.BLACKLISTED_MATERIALS.forEach(material -> {
                Material materialObj = Material.getMaterial((String)material);
                if (materialObj != null) {
                    this.blacklistedMaterialsList.add(materialObj);
                }
            });
        }
    }
}

