/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.config;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class ConfigSetup {
    private static File configFile;
    private static File sampleConfigFile;
    private static FileConfiguration configFileConfiguration;
    private static final int CURRENT_CONFIG_VERSION = 21;

    public static void setupConfig() {
        configFile = new File(FindItemAddOn.getInstance().getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            try {
                boolean isConfigGenerated = configFile.createNewFile();
                if (isConfigGenerated) {
                    Logger.logInfo("Generated a new config.yml");
                }
            }
            catch (IOException e) {
                Logger.logError("Error generating config.yml");
            }
        }
        configFileConfiguration = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public static void saveConfig() {
        try {
            configFileConfiguration.save(configFile);
        }
        catch (IOException e) {
            Logger.logError("Error saving config.yml");
        }
    }

    public static void checkForMissingProperties() {
        if (!configFileConfiguration.contains("search-loaded-shops-only", true)) {
            configFileConfiguration.set("search-loaded-shops-only", (Object)false);
        }
        if (!configFileConfiguration.contains("nearest-warp-mode", true)) {
            configFileConfiguration.set("nearest-warp-mode", (Object)1);
        } else {
            try {
                int nearestWarpMode = configFileConfiguration.getInt("nearest-warp-mode");
                if (nearestWarpMode != 1 && nearestWarpMode != 2 && nearestWarpMode != 3 && nearestWarpMode != 4) {
                    Logger.logError("Invalid value for 'nearest-warp-mode' in config.yml!");
                    Logger.logError("Resetting by default to &e1");
                    configFileConfiguration.set("nearest-warp-mode", (Object)1);
                }
            }
            catch (Exception e) {
                Logger.logError("Invalid value for 'nearest-warp-mode' in config.yml!");
                Logger.logError("Resetting by default to &e1");
                configFileConfiguration.set("nearest-warp-mode", (Object)1);
            }
        }
        if (!configFileConfiguration.contains("shop-gui-item-lore", true)) {
            ArrayList<String> shopGUIItemLore = new ArrayList<String>();
            shopGUIItemLore.add("");
            shopGUIItemLore.add("&fPrice: &a${ITEM_PRICE}");
            shopGUIItemLore.add("&fStock: &7{SHOP_STOCK}");
            shopGUIItemLore.add("&fOwner: &7{SHOP_OWNER}");
            shopGUIItemLore.add("&fLocation: &7{SHOP_LOC}");
            shopGUIItemLore.add("&fWorld: &7{SHOP_WORLD}");
            shopGUIItemLore.add("&fWarp: &7{NEAREST_WARP}");
            shopGUIItemLore.add("");
            configFileConfiguration.set("shop-gui-item-lore", shopGUIItemLore);
        }
        if (!configFileConfiguration.contains("blacklisted-worlds", true)) {
            ArrayList<String> blacklistedWorlds = new ArrayList<String>();
            blacklistedWorlds.add("world_number_1");
            blacklistedWorlds.add("world_number_2");
            configFileConfiguration.set("blacklisted-worlds", blacklistedWorlds);
        }
        if (!configFileConfiguration.contains("find-item-command.hideshop-autocomplete", true)) {
            configFileConfiguration.set("find-item-command.hideshop-autocomplete", (Object)"hideshop");
        }
        if (!configFileConfiguration.contains("find-item-command.revealshop-autocomplete", true)) {
            configFileConfiguration.set("find-item-command.revealshop-autocomplete", (Object)"revealshop");
        }
        if (!configFileConfiguration.contains("find-item-command.shop-hide-success-message", true)) {
            configFileConfiguration.set("find-item-command.shop-hide-success-message", (Object)"&aShop is now hidden from search list!");
        }
        if (!configFileConfiguration.contains("find-item-command.shop-reveal-success-message", true)) {
            configFileConfiguration.set("find-item-command.shop-reveal-success-message", (Object)"&aShop is no longer hidden from search list!");
        }
        if (!configFileConfiguration.contains("find-item-command.shop-already-hidden-message", true)) {
            configFileConfiguration.set("find-item-command.shop-already-hidden-message", (Object)"&cThis shop is already hidden!");
        }
        if (!configFileConfiguration.contains("find-item-command.shop-already-public-message", true)) {
            configFileConfiguration.set("find-item-command.shop-already-public-message", (Object)"&cThis shop is already public!");
        }
        if (!configFileConfiguration.contains("find-item-command.invalid-shop-block-message", true)) {
            configFileConfiguration.set("find-item-command.invalid-shop-block-message", (Object)"&cThe block you are looking at is not a shop!");
        }
        if (!configFileConfiguration.contains("find-item-command.hiding-shop-owner-invalid-message", true)) {
            configFileConfiguration.set("find-item-command.hiding-shop-owner-invalid-message", (Object)"&cThat shop is not yours!");
        }
        if (!configFileConfiguration.contains("config-version", true)) {
            configFileConfiguration.set("config-version", (Object)21);
        } else {
            if (configFileConfiguration.getInt("config-version") < 10) {
                boolean allowDirectShopTp = configFileConfiguration.getBoolean("allow-direct-shop-tp");
                String clickToTeleportMsg = configFileConfiguration.getString("click-to-teleport-message");
                String shopTPNoPermMsg = configFileConfiguration.getString("shop-tp-no-permission-message");
                String unsafeShopAreaMsg = configFileConfiguration.getString("unsafe-shop-area-message");
                configFileConfiguration.set("allow-direct-shop-tp", null);
                configFileConfiguration.set("click-to-teleport-message", null);
                configFileConfiguration.set("shop-tp-no-permission-message", null);
                configFileConfiguration.set("unsafe-shop-area-message", null);
                configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.tp-player-directly-to-shop", (Object)allowDirectShopTp);
                if (clickToTeleportMsg == null || clickToTeleportMsg.isEmpty()) {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.click-to-teleport-message", (Object)"&6&lClick to teleport to the shop!");
                } else {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.click-to-teleport-message", (Object)clickToTeleportMsg);
                }
                if (shopTPNoPermMsg == null || shopTPNoPermMsg.isEmpty()) {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.shop-tp-no-permission-message", (Object)"&cYou don't have permission to teleport to shop!");
                } else {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.shop-tp-no-permission-message", (Object)shopTPNoPermMsg);
                }
                if (unsafeShopAreaMsg == null || unsafeShopAreaMsg.isEmpty()) {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.unsafe-shop-area-message", (Object)"&cThe area around the shop is unsafe!");
                } else {
                    configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.unsafe-shop-area-message", (Object)unsafeShopAreaMsg);
                }
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.tp-player-to-nearest-warp", (Object)false);
            }
            if (configFileConfiguration.getInt("config-version") < 11) {
                ArrayList<String> cmdAliases = new ArrayList<String>();
                cmdAliases.add("searchshop");
                cmdAliases.add("shopsearch");
                cmdAliases.add("searchitem");
                configFileConfiguration.set("find-item-command.command-alias", cmdAliases);
                boolean warpState = configFileConfiguration.getBoolean("player-shop-teleportation.nearest-warp-tp-mode.warp-player-to-nearest-warp");
                if (warpState) {
                    configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.tp-player-to-nearest-warp", (Object)true);
                }
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.warp-player-to-nearest-warp", null);
                if (configFileConfiguration.getString("shop-gui-back-button-material").equalsIgnoreCase("RED_CONCRETE")) {
                    configFileConfiguration.set("shop-gui-back-button-material", (Object)"");
                }
                if (configFileConfiguration.getString("shop-gui-next-button-material").equalsIgnoreCase("GREEN_CONCRETE")) {
                    configFileConfiguration.set("shop-gui-next-button-material", (Object)"");
                }
                configFileConfiguration.set("shop-player-visit-cooldown-in-minutes", (Object)5);
            }
            if (configFileConfiguration.getInt("config-version") < 12) {
                configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.tp-delay-in-seconds", (Object)0);
                configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.tp-delay-message", (Object)"&6You will be teleported in &c{DELAY} &6seconds...");
            }
            if (configFileConfiguration.getInt("config-version") < 13) {
                configFileConfiguration.set("find-item-command.remove-hideshop-revealshop-subcommands", (Object)false);
                configFileConfiguration.set("player-shop-teleportation.direct-shop-tp-mode.tp-to-own-shop-no-permission-message", (Object)"&cYou cannot teleport to your own shop!");
                configFileConfiguration.set("ignore-empty-chests", (Object)true);
                configFileConfiguration.set("shop-gui-goto-first-page-button-material", (Object)"");
                configFileConfiguration.set("shop-gui-goto-first-page-button-text", (Object)"&7&l\u00ab &cGo to First Page");
                configFileConfiguration.set("shop-gui-goto-first-page-button-custom-model-data", (Object)"");
                configFileConfiguration.set("shop-gui-goto-last-page-button-material", (Object)"");
                configFileConfiguration.set("shop-gui-goto-last-page-button-text", (Object)"&aGo to Last Page &7&l\u00bb");
                configFileConfiguration.set("shop-gui-goto-last-page-button-custom-model-data", (Object)"");
            }
            if (configFileConfiguration.getInt("config-version") < 14) {
                configFileConfiguration.set("find-item-command.disable-search-all-shops", (Object)false);
            }
            if (configFileConfiguration.getInt("config-version") < 15) {
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.do-not-tp-if-warp-locked", (Object)true);
                String shopGuiBackButtonMaterial = configFileConfiguration.getString("shop-gui-back-button-material");
                String shopGuiBackButtonText = configFileConfiguration.getString("shop-gui-back-button-text");
                String shopGuiNextButtonMaterial = configFileConfiguration.getString("shop-gui-next-button-material");
                String shopGuiNNextButtonText = configFileConfiguration.getString("shop-gui-next-button-text");
                String shopGuiFillerItem = configFileConfiguration.getString("shop-gui-filler-item");
                String shopGuiCloseButtonMaterial = configFileConfiguration.getString("shop-gui-close-button-material");
                String shopGuiCloseButtonText = configFileConfiguration.getString("shop-gui-close-button-text");
                String shopGuiGotoFirstPageButtonMaterial = configFileConfiguration.getString("shop-gui-goto-first-page-button-material");
                String shopGuiGotoFirstPageButtonText = configFileConfiguration.getString("shop-gui-goto-first-page-button-text");
                String shopGuiGotoLastPageButtonMaterial = configFileConfiguration.getString("shop-gui-goto-last-page-button-material");
                String shopGuiGotoLastPageButtonText = configFileConfiguration.getString("shop-gui-goto-last-page-button-text");
                String shopNavFirstPageAlertMsg = configFileConfiguration.getString("shop-navigation-first-page-alert-message");
                String shopNavLastPageAlertMsg = configFileConfiguration.getString("shop-navigation-last-page-alert-message");
                String shopGuiBackButtonCMD = configFileConfiguration.getString("shop-gui-back-button-custom-model-data");
                String shopGuiNextButtonCMD = configFileConfiguration.getString("shop-gui-next-button-custom-model-data");
                String shopGuiCloseButtonCMD = configFileConfiguration.getString("shop-gui-close-button-custom-model-data");
                String shopGuiGotoFirstPageButtonCMD = configFileConfiguration.getString("shop-gui-goto-first-page-button-custom-model-data");
                String shopGuiGotoLastPageButtonCMD = configFileConfiguration.getString("shop-gui-goto-last-page-button-custom-model-data");
                configFileConfiguration.set("shop-gui-back-button-material", null);
                configFileConfiguration.set("shop-gui-back-button-text", null);
                configFileConfiguration.set("shop-gui-next-button-material", null);
                configFileConfiguration.set("shop-gui-next-button-text", null);
                configFileConfiguration.set("shop-gui-filler-item", null);
                configFileConfiguration.set("shop-gui-close-button-material", null);
                configFileConfiguration.set("shop-gui-close-button-text", null);
                configFileConfiguration.set("shop-gui-goto-first-page-button-material", null);
                configFileConfiguration.set("shop-gui-goto-first-page-button-text", null);
                configFileConfiguration.set("shop-gui-goto-last-page-button-material", null);
                configFileConfiguration.set("shop-gui-goto-last-page-button-text", null);
                configFileConfiguration.set("shop-navigation-first-page-alert-message", null);
                configFileConfiguration.set("shop-navigation-last-page-alert-message", null);
                configFileConfiguration.set("shop-gui-back-button-custom-model-data", null);
                configFileConfiguration.set("shop-gui-next-button-custom-model-data", null);
                configFileConfiguration.set("shop-gui-close-button-custom-model-data", null);
                configFileConfiguration.set("shop-navigation-first-page-button-custom-model-data", null);
                configFileConfiguration.set("shop-navigation-last-page-button-custom-model-data", null);
                configFileConfiguration.set("shop-gui-goto-first-page-button-custom-model-data", null);
                configFileConfiguration.set("shop-gui-goto-last-page-button-custom-model-data", null);
                String SHOP_GUI_OPTION = "shop-gui.";
                String SHOP_GUI_NAVIGATION_OPTION = "shop-navigation.";
                String SHOP_GUI_CMD_OPTION = "custom-model-data.";
                configFileConfiguration.set("shop-gui.back-button-material", (Object)shopGuiBackButtonMaterial);
                configFileConfiguration.set("shop-gui.back-button-text", (Object)shopGuiBackButtonText);
                configFileConfiguration.set("shop-gui.next-button-material", (Object)shopGuiNextButtonMaterial);
                configFileConfiguration.set("shop-gui.next-button-text", (Object)shopGuiNNextButtonText);
                configFileConfiguration.set("shop-gui.filler-item", (Object)shopGuiFillerItem);
                configFileConfiguration.set("shop-gui.close-button-material", (Object)shopGuiCloseButtonMaterial);
                configFileConfiguration.set("shop-gui.close-button-text", (Object)shopGuiCloseButtonText);
                configFileConfiguration.set("shop-gui.goto-first-page-button-material", (Object)shopGuiGotoFirstPageButtonMaterial);
                configFileConfiguration.set("shop-gui.goto-first-page-button-text", (Object)shopGuiGotoFirstPageButtonText);
                configFileConfiguration.set("shop-gui.goto-last-page-button-material", (Object)shopGuiGotoLastPageButtonMaterial);
                configFileConfiguration.set("shop-gui.goto-last-page-button-text", (Object)shopGuiGotoLastPageButtonText);
                configFileConfiguration.set("shop-gui.shop-navigation.first-page-alert-message", (Object)shopNavFirstPageAlertMsg);
                configFileConfiguration.set("shop-gui.shop-navigation.last-page-alert-message", (Object)shopNavLastPageAlertMsg);
                configFileConfiguration.set("shop-gui.custom-model-data.back-button-custom-model-data", (Object)shopGuiBackButtonCMD);
                configFileConfiguration.set("shop-gui.custom-model-data.next-button-custom-model-data", (Object)shopGuiNextButtonCMD);
                configFileConfiguration.set("shop-gui.custom-model-data.close-button-custom-model-data", (Object)shopGuiCloseButtonCMD);
                configFileConfiguration.set("shop-gui.custom-model-data.goto-first-page-button-custom-model-data", (Object)shopGuiGotoFirstPageButtonCMD);
                configFileConfiguration.set("shop-gui.custom-model-data.goto-last-page-button-custom-model-data", (Object)shopGuiGotoLastPageButtonCMD);
                configFileConfiguration.set("shop-gui.use-shorter-currency-format", (Object)false);
            }
            if (configFileConfiguration.getInt("config-version") < 16) {
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.only-show-player-owned-warps", (Object)true);
            }
            if (configFileConfiguration.getInt("config-version") < 17) {
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.use-residence-subzones", (Object)false);
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.no-warp-near-shop-error-message", (Object)"&cNo warp near this shop");
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.no-wg-region-near-shop-error-message", (Object)"&cNo WG Region near this shop");
                configFileConfiguration.set("player-shop-teleportation.nearest-warp-tp-mode.no-residence-near-shop-error-message", (Object)"&cNo residence Region near this shop");
            }
            if (configFileConfiguration.getInt("config-version") < 18) {
                configFileConfiguration.set("player-shop-teleportation.custom-commands.run-custom-commands", (Object)false);
                List<String> commands = Arrays.asList("tp {PLAYER_NAME} {SHOP_LOC_X} {SHOP_LOC_Y} {SHOP_LOC_Z}", "bal add 10000 {PLAYER_NAME}");
                configFileConfiguration.set("player-shop-teleportation.custom-commands.commands-list", commands);
            }
            if (configFileConfiguration.getInt("config-version") < 19) {
                configFileConfiguration.set("blacklisted-materials", ConfigSetup.populateSampleBlacklistedMaterials());
                configFileConfiguration.set("suppress-update-notifications", (Object)false);
            }
            if (configFileConfiguration.getInt("config-version") < 20) {
                configFileConfiguration.set("bentobox.ignore-locked-island-shops", (Object)true);
            }
            if (configFileConfiguration.getInt("config-version") < 21) {
                configFileConfiguration.set("shop-gui.custom-model-data.filler-item-custom-model-data", (Object)"");
            }
            String DEBUG_MODE_OPTION = "debug-mode";
            String CONFIG_VERSION_OPTION = "config-version";
            boolean userDefinedDebugMode = configFileConfiguration.getBoolean("debug-mode");
            configFileConfiguration.set("debug-mode", null);
            configFileConfiguration.set("debug-mode", (Object)userDefinedDebugMode);
            configFileConfiguration.set("config-version", null);
            configFileConfiguration.set("config-version", (Object)21);
        }
    }

    @NotNull
    private static List<String> populateSampleBlacklistedMaterials() {
        ArrayList<String> blacklistedMaterials = new ArrayList<String>();
        blacklistedMaterials.add("BARRIER");
        blacklistedMaterials.add("STRUCTURE_BLOCK");
        blacklistedMaterials.add("COMMAND_BLOCK");
        blacklistedMaterials.add("CHAIN_COMMAND_BLOCK");
        blacklistedMaterials.add("REPEATING_COMMAND_BLOCK");
        blacklistedMaterials.add("COMMAND_BLOCK_MINECART");
        blacklistedMaterials.add("JIGSAW");
        blacklistedMaterials.add("DEBUG_STICK");
        blacklistedMaterials.add("LIGHT");
        blacklistedMaterials.add("STRUCTURE_VOID");
        return blacklistedMaterials;
    }

    public static FileConfiguration get() {
        return configFileConfiguration;
    }

    public static void reloadConfig() {
        configFileConfiguration = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public static void copySampleConfig() {
        FindItemAddOn.getInstance().saveResource("sample-config.yml", true);
    }

    @Generated
    private ConfigSetup() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static int getCURRENT_CONFIG_VERSION() {
        return 21;
    }
}

