/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.dependencies;

import com.earth2me.essentials.Essentials;
import io.myzticbean.finditemaddon.models.EssentialWarpModel;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class EssentialsXPlugin {
    private static Essentials essAPI = null;
    private static List<EssentialWarpModel> allWarpsList = null;

    public static void setup() {
        if (Bukkit.getPluginManager().isPluginEnabled("Essentials") && (essAPI = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials")) != null) {
            Logger.logInfo("Found Essentials");
        }
    }

    public static boolean isEnabled() {
        return essAPI != null;
    }

    public static Essentials getAPI() {
        return essAPI;
    }

    public static List<EssentialWarpModel> getAllWarps() {
        return allWarpsList;
    }

    public static void updateAllWarps() {
        if (!essAPI.isEnabled()) {
            return;
        }
        long start = System.currentTimeMillis();
        Collection allWarps = EssentialsXPlugin.getAPI().getWarps().getList();
        allWarpsList = new ArrayList<EssentialWarpModel>();
        for (String warp : allWarps) {
            EssentialsXPlugin.addWarpToList(warp);
        }
        EssentialsXPlugin.logUpdateCompletion(start);
    }

    private static void addWarpToList(String warp) {
        try {
            EssentialWarpModel essWarp = new EssentialWarpModel();
            essWarp.warpName = warp;
            essWarp.warpLoc = essAPI.getWarps().getWarp(warp);
            allWarpsList.add(essWarp);
        }
        catch (Exception ignored) {
            Logger.logError("Error adding warp to list: " + warp);
        }
    }

    private static void logUpdateCompletion(long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        Logger.logDebugInfo(String.format("Update complete for Essentials warps list! Found %d warps. Time took: %dms.", EssentialsXPlugin.getAllWarps().size(), duration));
    }

    public static void setLastLocation(Player player) {
        if (essAPI.isEnabled()) {
            EssentialsXPlugin.getAPI().getUser(player).setLastLocation();
        }
    }

    @Generated
    private EssentialsXPlugin() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

