/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.handlers.command;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.config.ConfigSetup;
import io.myzticbean.finditemaddon.handlers.gui.menus.FoundShopsMenu;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.quickshop.impl.QSHikariAPIHandler;
import io.myzticbean.finditemaddon.quickshop.impl.QSReremakeAPIHandler;
import io.myzticbean.finditemaddon.utils.PlayerUtil;
import io.myzticbean.finditemaddon.utils.async.VirtualThreadScheduler;
import io.myzticbean.finditemaddon.utils.json.HiddenShopStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import io.myzticbean.finditemaddon.utils.warp.WarpUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.maxgamer.quickshop.api.shop.Shop;

public class CmdExecutorHandler {
    private static final String THIS_COMMAND_CAN_ONLY_BE_RUN_FROM_IN_GAME = "This command can only be run from in game";
    public static final String NO_PERMISSION = "&cNo permission!";

    public void handleShopSearch(String buySellSubCommand, CommandSender commandSender, String itemArg) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            if (!(commandSender instanceof Player)) {
                Logger.logInfo(THIS_COMMAND_CAN_ONLY_BE_RUN_FROM_IN_GAME);
                return;
            }
            Player player = (Player)commandSender;
            if (!player.hasPermission(PlayerPermsEnum.FINDITEM_USE.value())) {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
                return;
            }
            if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_SEARCH_LOADING_MSG)) {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().SHOP_SEARCH_LOADING_MSG);
            }
            boolean isBuying = StringUtils.isEmpty(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE) || StringUtils.containsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE, " ") ? buySellSubCommand.equalsIgnoreCase("to_buy") : buySellSubCommand.equalsIgnoreCase(FindItemAddOn.getConfigProvider().FIND_ITEM_TO_BUY_AUTOCOMPLETE);
            if (itemArg.equalsIgnoreCase("*") && !FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_DISABLE_SEARCH_ALL_SHOPS) {
                FindItemAddOn.getQsApiInstance().fetchAllItemsFromAllShops(isBuying, player).thenAccept(searchResultList -> this.openShopMenu(player, (List<FoundShopItemModel>)searchResultList, FindItemAddOn.getConfigProvider().NO_SHOP_FOUND_MSG));
            } else {
                Material mat = Material.getMaterial((String)itemArg.toUpperCase());
                if (this.checkMaterialBlacklist(mat)) {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&cThis material is not allowed.");
                    return;
                }
                if (mat != null && mat.isItem()) {
                    Logger.logDebugInfo("Material found: " + String.valueOf(mat));
                    FindItemAddOn.getQsApiInstance().findItemBasedOnTypeFromAllShops(new ItemStack(mat), isBuying, player).thenAccept(searchResultList -> this.openShopMenu(player, (List<FoundShopItemModel>)searchResultList, FindItemAddOn.getConfigProvider().NO_SHOP_FOUND_MSG));
                } else {
                    Logger.logDebugInfo("Material not found! Performing query based search..");
                    FindItemAddOn.getQsApiInstance().findItemBasedOnDisplayNameFromAllShops(itemArg, isBuying, player).thenAccept(searchResultList -> this.openShopMenu(player, (List<FoundShopItemModel>)searchResultList, FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INVALID_MATERIAL_MSG));
                }
            }
        });
    }

    private void openShopMenu(Player player, List<FoundShopItemModel> searchResultList, String errorMsg) {
        if (!searchResultList.isEmpty()) {
            FoundShopsMenu menu = new FoundShopsMenu(FindItemAddOn.getPlayerMenuUtility(player), searchResultList);
            menu.open(searchResultList);
        } else if (!StringUtils.isEmpty(errorMsg)) {
            PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + errorMsg);
        }
    }

    private boolean checkMaterialBlacklist(Material mat) {
        return FindItemAddOn.getConfigProvider().getBlacklistedMaterials().contains(mat);
    }

    public void handleHideShop(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (player.hasPermission(PlayerPermsEnum.FINDITEM_HIDESHOP.value())) {
                Block playerLookAtBlock = player.getTargetBlock(null, 3);
                Logger.logDebugInfo("TargetBlock found: " + String.valueOf(playerLookAtBlock.getType()));
                if (FindItemAddOn.isQSReremakeInstalled()) {
                    this.hideReremakeShop((Shop)FindItemAddOn.getQsApiInstance().findShopAtLocation(playerLookAtBlock), player);
                } else {
                    this.hideHikariShop((com.ghostchu.quickshop.api.shop.Shop)FindItemAddOn.getQsApiInstance().findShopAtLocation(playerLookAtBlock), player);
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
            }
        } else {
            Logger.logInfo(THIS_COMMAND_CAN_ONLY_BE_RUN_FROM_IN_GAME);
        }
    }

    public void handleRevealShop(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (player.hasPermission(PlayerPermsEnum.FINDITEM_HIDESHOP.value())) {
                Block playerLookAtBlock = player.getTargetBlock(null, 5);
                if (playerLookAtBlock != null) {
                    Logger.logDebugInfo("TargetBlock found: " + String.valueOf(playerLookAtBlock.getType()));
                    if (FindItemAddOn.isQSReremakeInstalled()) {
                        this.revealShop((Shop)FindItemAddOn.getQsApiInstance().findShopAtLocation(playerLookAtBlock), player);
                    } else {
                        this.revealShop((com.ghostchu.quickshop.api.shop.Shop)FindItemAddOn.getQsApiInstance().findShopAtLocation(playerLookAtBlock), player);
                    }
                } else {
                    Logger.logDebugInfo("TargetBlock is null!");
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
            }
        } else {
            Logger.logInfo(THIS_COMMAND_CAN_ONLY_BE_RUN_FROM_IN_GAME);
        }
    }

    public void handlePluginReload(CommandSender commandSender) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                if (player.hasPermission(PlayerPermsEnum.FINDITEM_RELOAD.value()) || player.hasPermission(PlayerPermsEnum.FINDITEM_ADMIN.value())) {
                    ConfigSetup.reloadConfig();
                    ConfigSetup.checkForMissingProperties();
                    ConfigSetup.saveConfig();
                    FindItemAddOn.initConfigProvider();
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&aConfig reloaded!");
                    List<?> allServerShops = FindItemAddOn.getQsApiInstance().getAllShops();
                    if (allServerShops.isEmpty()) {
                        PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&6Found &e0 &6shops on the server. If you ran &e/qs reload &6recently, please restart your server!");
                    } else {
                        PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&aFound &e" + allServerShops.size() + " &ashops on the server.");
                    }
                    WarpUtils.updateWarps();
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
                }
            } else {
                ConfigSetup.reloadConfig();
                ConfigSetup.checkForMissingProperties();
                ConfigSetup.saveConfig();
                FindItemAddOn.initConfigProvider();
                List<?> allServerShops = FindItemAddOn.getQsApiInstance().getAllShops();
                if (allServerShops.isEmpty()) {
                    Logger.logWarning("&6Found &e0 &6shops on the server. If you ran &e/qs reload &6recently, please restart your server!");
                } else {
                    Logger.logInfo("&aFound &e" + allServerShops.size() + " &ashops on the server.");
                }
                WarpUtils.updateWarps();
            }
        });
    }

    @Deprecated(forRemoval=true)
    public void handlePluginRestart(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            Bukkit.getPluginManager().disablePlugin(FindItemAddOn.getInstance());
            Bukkit.getPluginManager().enablePlugin((Plugin)FindItemAddOn.getPlugin(FindItemAddOn.class));
            Logger.logInfo("&aPlugin restarted!");
            List<?> allServerShops = FindItemAddOn.getQsApiInstance().getAllShops();
            if (allServerShops.size() == 0) {
                Logger.logWarning("&6Found &e0 &6shops on the server. If you ran &e/qs reload &6recently, please restart your server!");
            } else {
                Logger.logInfo("&aFound &e" + allServerShops.size() + " &ashops on the server.");
            }
        } else {
            Player player = (Player)commandSender;
            if (player.hasPermission(PlayerPermsEnum.FINDITEM_RESTART.value()) || player.hasPermission(PlayerPermsEnum.FINDITEM_ADMIN.value())) {
                Bukkit.getPluginManager().disablePlugin(FindItemAddOn.getInstance());
                Bukkit.getPluginManager().enablePlugin((Plugin)FindItemAddOn.getPlugin(FindItemAddOn.class));
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&aPlugin restarted!");
                List<?> allServerShops = FindItemAddOn.getQsApiInstance().getAllShops();
                if (allServerShops.size() == 0) {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&6Found &e0 &6shops on the server. If you ran &e/qs reload &6recently, please restart your server!");
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + "&aFound &e" + allServerShops.size() + " &ashops on the server.");
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
            }
        }
    }

    private void hideReremakeShop(Shop shop, Player player) {
        if (shop != null) {
            QSReremakeAPIHandler qsReremakeAPIHandler = (QSReremakeAPIHandler)FindItemAddOn.getQsApiInstance();
            if (qsReremakeAPIHandler.isShopOwnerCommandRunner(player, shop)) {
                if (!HiddenShopStorageUtil.isShopHidden(shop)) {
                    HiddenShopStorageUtil.handleShopSearchVisibilityAsync(shop, true);
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_HIDE_SUCCESS_MSG);
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_ALREADY_HIDDEN_MSG);
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_HIDING_SHOP_OWNER_INVALID_MSG);
            }
        } else {
            PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INVALID_SHOP_BLOCK_MSG);
        }
    }

    private void hideHikariShop(com.ghostchu.quickshop.api.shop.Shop shop, Player player) {
        if (shop != null) {
            QSHikariAPIHandler qsHikariAPIHandler = (QSHikariAPIHandler)FindItemAddOn.getQsApiInstance();
            if (qsHikariAPIHandler.isShopOwnerCommandRunner(player, shop)) {
                if (!HiddenShopStorageUtil.isShopHidden(shop)) {
                    HiddenShopStorageUtil.handleShopSearchVisibilityAsync(shop, true);
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_HIDE_SUCCESS_MSG);
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_ALREADY_HIDDEN_MSG);
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_HIDING_SHOP_OWNER_INVALID_MSG);
            }
        } else {
            PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INVALID_SHOP_BLOCK_MSG);
        }
    }

    private void revealShop(Shop shop, Player player) {
        if (shop != null) {
            QSReremakeAPIHandler qsReremakeAPIHandler = (QSReremakeAPIHandler)FindItemAddOn.getQsApiInstance();
            if (qsReremakeAPIHandler.isShopOwnerCommandRunner(player, shop)) {
                if (HiddenShopStorageUtil.isShopHidden(shop)) {
                    HiddenShopStorageUtil.handleShopSearchVisibilityAsync(shop, false);
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_REVEAL_SUCCESS_MSG);
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_ALREADY_PUBLIC_MSG);
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_HIDING_SHOP_OWNER_INVALID_MSG);
            }
        } else {
            PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INVALID_SHOP_BLOCK_MSG);
        }
    }

    private void revealShop(com.ghostchu.quickshop.api.shop.Shop shop, Player player) {
        if (shop != null) {
            QSHikariAPIHandler qsHikariAPIHandler = (QSHikariAPIHandler)FindItemAddOn.getQsApiInstance();
            if (qsHikariAPIHandler.isShopOwnerCommandRunner(player, shop)) {
                if (HiddenShopStorageUtil.isShopHidden(shop)) {
                    HiddenShopStorageUtil.handleShopSearchVisibilityAsync(shop, false);
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_REVEAL_SUCCESS_MSG);
                } else {
                    PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_SHOP_ALREADY_PUBLIC_MSG);
                }
            } else {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_HIDING_SHOP_OWNER_INVALID_MSG);
            }
        } else {
            PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + FindItemAddOn.getConfigProvider().FIND_ITEM_CMD_INVALID_SHOP_BLOCK_MSG);
        }
    }

    public void handleDebugMode(CommandSender commandSender, String[] args) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            Player player;
            if (args.length == 1) {
                if (commandSender instanceof Player) {
                    Player player2 = (Player)commandSender;
                    PlayerUtil.sendMessage((HumanEntity)player2, this.getPluginPrefix() + "&7Debug is currently " + (FindItemAddOn.getConfigProvider().isDebugModeEnabled() ? "enabled." : "disabled.") + "\nYou can change it by typing &e/finditemadmin debug-mode {enable | disable}\n");
                } else {
                    Logger.logInfo("\n\nDebug is currently " + (FindItemAddOn.getConfigProvider().isDebugModeEnabled() ? "enabled." : "disabled.") + "\nYou can change it by typing /finditemadmin debug-mode {enable | disable}\n");
                }
                return;
            }
            String mode = args[1];
            boolean enable = mode.equalsIgnoreCase("enable");
            if (commandSender instanceof Player && !PlayerUtil.hasPermission(player = (Player)commandSender, PlayerPermsEnum.FINDITEM_ADMIN.value())) {
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + NO_PERMISSION);
                return;
            }
            FindItemAddOn.getConfigProvider().setDebugMode(enable);
            String message = "Debug mode " + (enable ? "enabled" : "disabled") + " successfully.";
            if (commandSender instanceof Player) {
                player = (Player)commandSender;
                PlayerUtil.sendMessage((HumanEntity)player, this.getPluginPrefix() + message);
            } else {
                Logger.logInfo(message);
            }
        });
    }

    public String getPluginPrefix() {
        return FindItemAddOn.getConfigProvider().PLUGIN_PREFIX;
    }
}

