/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.handlers.gui;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.handlers.gui.Menu;
import io.myzticbean.finditemaddon.handlers.gui.PlayerMenuUtility;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public abstract class PaginatedMenu
extends Menu {
    private static final Gson gson = new Gson();
    protected int page = 0;
    protected int index = 0;
    protected ItemStack backButton;
    protected ItemStack firstPageButton;
    protected ItemStack nextButton;
    protected ItemStack lastPageButton;
    protected ItemStack closeInvButton;
    protected static final int MAX_ITEMS_PER_PAGE = 45;
    private final String BACK_BUTTON_SKIN_ID = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjZkYWI3MjcxZjRmZjA0ZDU0NDAyMTkwNjdhMTA5YjVjMGMxZDFlMDFlYzYwMmMwMDIwNDc2ZjdlYjYxMjE4MCJ9fX0=";
    private final String FIRST_PAGE_BUTTON_SKIN_ID = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTI5M2E2MDcwNTAzMTcyMDcxZjM1ZjU4YzgyMjA0ZTgxOGNkMDY1MTg2OTAxY2ExOWY3ZGFkYmRhYzE2NWU0NCJ9fX0=";
    private final String NEXT_BUTTON_SKIN_ID = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGFhMTg3ZmVkZTg4ZGUwMDJjYmQ5MzA1NzVlYjdiYTQ4ZDNiMWEwNmQ5NjFiZGM1MzU4MDA3NTBhZjc2NDkyNiJ9fX0=";
    private final String LAST_PAGE_BUTTON_SKIN_ID = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWRhNDRjNzY3Y2NhMjU4NjFkM2E1MmZlMTdjMjY0MjhlNjYwZWUyM2RjMGQ3OTNiZjdiZDg2ZWEyMDJmNzAzZCJ9fX0=";

    protected PaginatedMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
        this.initMaterialsForBottomBar();
    }

    protected PaginatedMenu(PlayerMenuUtility playerMenuUtility, List<FoundShopItemModel> searchResult) {
        super(playerMenuUtility);
        this.initMaterialsForBottomBar();
        this.playerMenuUtility.setPlayerShopSearchResult(searchResult);
    }

    private void initMaterialsForBottomBar() {
        this.createGUIBackButton();
        this.createGUIFirstPageButton();
        this.createGUINextButton();
        this.createGUILastPageButton();
        this.createGUICloseInvButton();
    }

    public void addMenuBottomBar() {
        this.inventory.setItem(45, this.backButton);
        this.inventory.setItem(46, this.firstPageButton);
        this.inventory.setItem(53, this.nextButton);
        this.inventory.setItem(52, this.lastPageButton);
        this.inventory.setItem(49, this.closeInvButton);
        this.inventory.setItem(47, this.GUI_FILLER_ITEM);
        this.inventory.setItem(48, this.GUI_FILLER_ITEM);
        this.inventory.setItem(50, this.GUI_FILLER_ITEM);
        this.inventory.setItem(51, this.GUI_FILLER_ITEM);
    }

    private void createGUIBackButton() {
        Material backButtonMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_BACK_BUTTON_MATERIAL);
        this.backButton = backButtonMaterial == null ? this.createPlayerHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjZkYWI3MjcxZjRmZjA0ZDU0NDAyMTkwNjdhMTA5YjVjMGMxZDFlMDFlYzYwMmMwMDIwNDc2ZjdlYjYxMjE4MCJ9fX0=") : new ItemStack(backButtonMaterial);
        ItemMeta backButtonMeta = this.backButton.getItemMeta();
        assert (backButtonMeta != null);
        if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_BACK_BUTTON_TEXT)) {
            backButtonMeta.setDisplayName(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().SHOP_GUI_BACK_BUTTON_TEXT));
        }
        try {
            if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_BACK_BUTTON_CMD)) {
                int backButtonCMD = Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_BACK_BUTTON_CMD);
                backButtonMeta.setCustomModelData(Integer.valueOf(backButtonCMD));
            }
        }
        catch (NumberFormatException e) {
            Logger.logDebugInfo("Invalid Custom Model Data for Back Button in config.yml");
        }
        this.backButton.setItemMeta(backButtonMeta);
    }

    private void createGUINextButton() {
        Material nextButtonMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_NEXT_BUTTON_MATERIAL);
        this.nextButton = nextButtonMaterial == null ? this.createPlayerHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGFhMTg3ZmVkZTg4ZGUwMDJjYmQ5MzA1NzVlYjdiYTQ4ZDNiMWEwNmQ5NjFiZGM1MzU4MDA3NTBhZjc2NDkyNiJ9fX0=") : new ItemStack(nextButtonMaterial);
        ItemMeta nextButtonMeta = this.nextButton.getItemMeta();
        assert (nextButtonMeta != null);
        if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_NEXT_BUTTON_TEXT)) {
            nextButtonMeta.setDisplayName(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().SHOP_GUI_NEXT_BUTTON_TEXT));
        }
        try {
            if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_NEXT_BUTTON_CMD)) {
                int nextButtonCMD = Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_NEXT_BUTTON_CMD);
                nextButtonMeta.setCustomModelData(Integer.valueOf(nextButtonCMD));
            }
        }
        catch (NumberFormatException e) {
            Logger.logDebugInfo("Invalid Custom Model Data for Next Button in config.yml");
        }
        this.nextButton.setItemMeta(nextButtonMeta);
    }

    private void createGUIFirstPageButton() {
        Material firstPageButtonMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_MATERIAL);
        this.firstPageButton = firstPageButtonMaterial == null ? this.createPlayerHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTI5M2E2MDcwNTAzMTcyMDcxZjM1ZjU4YzgyMjA0ZTgxOGNkMDY1MTg2OTAxY2ExOWY3ZGFkYmRhYzE2NWU0NCJ9fX0=") : new ItemStack(firstPageButtonMaterial);
        ItemMeta firstPageButtonMeta = this.firstPageButton.getItemMeta();
        if (firstPageButtonMeta != null && !StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_TEXT)) {
            firstPageButtonMeta.setDisplayName(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_TEXT));
        }
        try {
            if (firstPageButtonMeta != null && !StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_CMD)) {
                int firstPageButtonCMD = Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_FIRST_PAGE_BUTTON_CMD);
                firstPageButtonMeta.setCustomModelData(Integer.valueOf(firstPageButtonCMD));
            }
        }
        catch (NumberFormatException e) {
            Logger.logDebugInfo("Invalid Custom Model Data for Goto First Page Button in config.yml");
        }
        this.firstPageButton.setItemMeta(firstPageButtonMeta);
    }

    private void createGUILastPageButton() {
        Material lastPageButtonMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_LAST_PAGE_BUTTON_MATERIAL);
        this.lastPageButton = lastPageButtonMaterial == null ? this.createPlayerHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWRhNDRjNzY3Y2NhMjU4NjFkM2E1MmZlMTdjMjY0MjhlNjYwZWUyM2RjMGQ3OTNiZjdiZDg2ZWEyMDJmNzAzZCJ9fX0=") : new ItemStack(lastPageButtonMaterial);
        ItemMeta lastPageButtonMeta = this.lastPageButton.getItemMeta();
        if (lastPageButtonMeta != null && !StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_LAST_PAGE_BUTTON_TEXT)) {
            lastPageButtonMeta.setDisplayName(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_LAST_PAGE_BUTTON_TEXT));
        }
        try {
            if (lastPageButtonMeta != null && !StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_LAST_PAGE_BUTTON_CMD)) {
                int lastPageButtonCMD = Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_GOTO_LAST_PAGE_BUTTON_CMD);
                lastPageButtonMeta.setCustomModelData(Integer.valueOf(lastPageButtonCMD));
            }
        }
        catch (NumberFormatException e) {
            Logger.logDebugInfo("Invalid Custom Model Data for Goto Last Page Button in config.yml");
        }
        this.lastPageButton.setItemMeta(lastPageButtonMeta);
    }

    private void createGUICloseInvButton() {
        Material closeInvButtonMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_CLOSE_BUTTON_MATERIAL);
        if (closeInvButtonMaterial == null) {
            closeInvButtonMaterial = Material.BARRIER;
        }
        this.closeInvButton = new ItemStack(closeInvButtonMaterial);
        ItemMeta closeInvMeta = this.closeInvButton.getItemMeta();
        assert (closeInvMeta != null);
        if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_CLOSE_BUTTON_TEXT)) {
            closeInvMeta.setDisplayName(ColorTranslator.translateColorCodes(FindItemAddOn.getConfigProvider().SHOP_GUI_CLOSE_BUTTON_TEXT));
        }
        try {
            if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_CLOSE_BUTTON_CMD)) {
                int closeInvButtonCMD = Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_CLOSE_BUTTON_CMD);
                closeInvMeta.setCustomModelData(Integer.valueOf(closeInvButtonCMD));
            }
        }
        catch (NumberFormatException e) {
            Logger.logDebugInfo("Invalid Custom Model Data for Close Button in config.yml");
        }
        this.closeInvButton.setItemMeta(closeInvMeta);
    }

    private ItemStack createPlayerHead(String textureValue) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), null);
            PlayerTextures textures = profile.getTextures();
            try {
                String decodedValue = new String(Base64.getDecoder().decode(textureValue));
                Logger.logDebugInfo("Decoded Value: " + decodedValue);
                String textureUrl = this.extractTextureUrl(decodedValue);
                URL url = new URL(textureUrl);
                textures.setSkin(url);
            }
            catch (Exception e) {
                Logger.logError(e);
            }
            profile.setTextures(textures);
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
        }
        return head;
    }

    private String extractTextureUrl(String decodedValue) {
        JsonObject jsonObject = gson.fromJson(decodedValue, JsonObject.class);
        return jsonObject.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
    }
}

