/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.handlers.gui.menus;

import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.olziedev.playerwarps.api.warp.Warp;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.config.ConfigProvider;
import io.myzticbean.finditemaddon.dependencies.EssentialsXPlugin;
import io.myzticbean.finditemaddon.dependencies.PlayerWarpsPlugin;
import io.myzticbean.finditemaddon.dependencies.ResidencePlugin;
import io.myzticbean.finditemaddon.dependencies.WGPlugin;
import io.myzticbean.finditemaddon.handlers.gui.PaginatedMenu;
import io.myzticbean.finditemaddon.handlers.gui.PlayerMenuUtility;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.enums.CustomCmdPlaceholdersEnum;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.models.enums.ShopLorePlaceholdersEnum;
import io.myzticbean.finditemaddon.utils.LocationUtils;
import io.myzticbean.finditemaddon.utils.PlayerUtil;
import io.myzticbean.finditemaddon.utils.async.VirtualThreadScheduler;
import io.myzticbean.finditemaddon.utils.json.ShopSearchActivityStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import io.myzticbean.finditemaddon.utils.warp.EssentialWarpsUtil;
import io.myzticbean.finditemaddon.utils.warp.PlayerWarpsUtil;
import io.myzticbean.finditemaddon.utils.warp.ResidenceUtils;
import io.myzticbean.finditemaddon.utils.warp.WGRegionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundShopsMenu
extends PaginatedMenu {
    public static final String SHOP_STOCK_UNLIMITED = "Unlimited";
    public static final String SHOP_STOCK_UNKNOWN = "Unknown";
    private static final String NAMEDSPACE_KEY_LOCATION_DATA = "locationData";
    private final ConfigProvider configProvider = FindItemAddOn.getConfigProvider();

    public FoundShopsMenu(PlayerMenuUtility playerMenuUtility, List<FoundShopItemModel> searchResult) {
        super(playerMenuUtility, searchResult);
    }

    @Override
    public String getMenuName() {
        if (!StringUtils.isEmpty(this.configProvider.SHOP_SEARCH_GUI_TITLE)) {
            return ColorTranslator.translateColorCodes(this.configProvider.SHOP_SEARCH_GUI_TITLE);
        }
        return ColorTranslator.translateColorCodes("&l\u00bb &rShops");
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(@NotNull InventoryClickEvent event) {
        int slot = event.getSlot();
        Player player = (Player)event.getWhoClicked();
        if (this.handleNavigationClick(event, slot)) {
            return;
        }
        if (slot == 49) {
            player.closeInventory();
            return;
        }
        if (event.getCurrentItem().getType().equals((Object)Material.AIR)) {
            Logger.logDebugInfo(player.getName() + " just clicked on AIR!");
            return;
        }
        this.handleShopItemClick(event, player);
    }

    private boolean handleNavigationClick(InventoryClickEvent event, int slot) {
        return switch (slot) {
            case 45 -> {
                this.handleMenuClickForNavToPrevPage(event);
                yield true;
            }
            case 46 -> {
                this.handleFirstPageClick(event);
                yield true;
            }
            case 52 -> {
                this.handleLastPageClick(event);
                yield true;
            }
            case 53 -> {
                this.handleMenuClickForNavToNextPage(event);
                yield true;
            }
            default -> false;
        };
    }

    private void handleShopItemClick(@NotNull InventoryClickEvent event, Player player) {
        ItemStack item = event.getCurrentItem();
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey(FindItemAddOn.getInstance(), NAMEDSPACE_KEY_LOCATION_DATA);
        if (!meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            Logger.logError("PersistentDataContainer doesn't have the right kind of data!");
            return;
        }
        String locData = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        List<String> locDataList = Arrays.asList(locData.split("\\s*\\|\\|\\|\\s*"));
        if (this.configProvider.TP_PLAYER_DIRECTLY_TO_SHOP && locDataList.size() > 1) {
            this.handleDirectShopTeleport(player, locDataList);
        } else if (this.configProvider.TP_PLAYER_TO_NEAREST_WARP && locDataList.size() == 1 && !locDataList.get(0).isEmpty()) {
            this.handleWarpTeleport(player, locDataList.get(0));
        }
        this.handleCustomCommands(player, locDataList);
        player.closeInventory();
    }

    private void handleDirectShopTeleport(@NotNull Player player, List<String> locDataList) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            if (!PlayerUtil.hasPermission(player, PlayerPermsEnum.FINDITEM_SHOPTP.value())) {
                this.sendNoPermissionMessage(player);
                return;
            }
            Location shopLocation = this.parseShopLocation(locDataList);
            if (shopLocation == null) {
                return;
            }
            UUID shopOwner = ShopSearchActivityStorageUtil.getShopOwnerUUID(shopLocation);
            if (player.getUniqueId().equals(shopOwner) && !PlayerPermsEnum.canPlayerTpToOwnShop(player)) {
                PlayerUtil.sendMessage((HumanEntity)player, this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_TP_NO_PERMISSION_MSG);
                return;
            }
            Location locToTeleport = LocationUtils.findSafeLocationAroundShop(shopLocation, player);
            if (locToTeleport == null) {
                this.sendUnsafeAreaMessage(player);
                return;
            }
            ShopSearchActivityStorageUtil.addPlayerVisitEntryAsync(shopLocation, player);
            if (EssentialsXPlugin.isEnabled()) {
                EssentialsXPlugin.setLastLocation(player);
            }
            if (this.shouldApplyTeleportDelay(player)) {
                this.applyTeleportDelay(player, locToTeleport);
            } else {
                PlayerUtil.teleport(player, locToTeleport);
            }
        });
    }

    private void handleWarpTeleport(Player player, String warpName) {
        switch (this.configProvider.NEAREST_WARP_MODE) {
            case 1: {
                EssentialWarpsUtil.warpPlayer(player, warpName);
                break;
            }
            case 2: {
                PlayerWarpsUtil.executeWarpPlayer(player, warpName);
                break;
            }
            case 4: {
                ResidenceUtils.residenceTp(player, warpName);
            }
        }
    }

    private void handleCustomCommands(Player player, List<String> locDataList) {
        if (this.configProvider.CUSTOM_CMDS_RUN_ENABLED && !this.configProvider.CUSTOM_CMDS_LIST.isEmpty() && locDataList.size() > 1) {
            Location shopLocation = this.parseShopLocation(locDataList);
            if (shopLocation == null) {
                return;
            }
            for (String cmd : this.configProvider.CUSTOM_CMDS_LIST) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.replaceCustomCmdPlaceholders(cmd, player, shopLocation));
            }
        }
    }

    @Nullable
    private Location parseShopLocation(@NotNull List<String> locDataList) {
        if (locDataList.size() <= 1) {
            return null;
        }
        World world = Bukkit.getWorld((String)locDataList.get(0));
        int locX = Integer.parseInt(locDataList.get(1));
        int locY = Integer.parseInt(locDataList.get(2));
        int locZ = Integer.parseInt(locDataList.get(3));
        return new Location(world, (double)locX, (double)locY, (double)locZ);
    }

    private void sendNoPermissionMessage(Player player) {
        if (!StringUtils.isEmpty(this.configProvider.SHOP_TP_NO_PERMISSION_MSG)) {
            PlayerUtil.sendMessage((HumanEntity)player, this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_TP_NO_PERMISSION_MSG);
        }
    }

    private void sendUnsafeAreaMessage(Player player) {
        if (!StringUtils.isEmpty(this.configProvider.UNSAFE_SHOP_AREA_MSG)) {
            PlayerUtil.sendMessage((HumanEntity)player, this.configProvider.PLUGIN_PREFIX + this.configProvider.UNSAFE_SHOP_AREA_MSG);
        }
    }

    private boolean shouldApplyTeleportDelay(Player player) {
        return StringUtils.isNumeric(this.configProvider.TP_DELAY_IN_SECONDS) && !"0".equals(this.configProvider.TP_DELAY_IN_SECONDS) && !PlayerPermsEnum.hasShopTpDelayBypassPermOrAdmin(player);
    }

    private void applyTeleportDelay(Player player, Location locToTeleport) {
        long delay = Long.parseLong(this.configProvider.TP_DELAY_IN_SECONDS);
        Logger.logDebugInfo("Teleporting delay is set to: " + delay);
        String tpDelayMsg = this.configProvider.TP_DELAY_MESSAGE;
        if (!StringUtils.isEmpty(tpDelayMsg)) {
            PlayerUtil.sendMessage((HumanEntity)player, this.configProvider.PLUGIN_PREFIX + this.replaceDelayPlaceholder(tpDelayMsg, delay));
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(FindItemAddOn.getInstance(), () -> PlayerUtil.teleport(player, locToTeleport), delay * 20L);
    }

    private void handleMenuClickForNavToNextPage(InventoryClickEvent event) {
        if (this.index + 1 < this.playerMenuUtility.getPlayerShopSearchResult().size()) {
            ++this.page;
            super.open(this.playerMenuUtility.getPlayerShopSearchResult());
        } else if (!StringUtils.isEmpty(this.configProvider.SHOP_NAV_LAST_PAGE_ALERT_MSG)) {
            PlayerUtil.sendMessage(event.getWhoClicked(), this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_NAV_LAST_PAGE_ALERT_MSG);
        }
    }

    private void handleMenuClickForNavToPrevPage(InventoryClickEvent event) {
        if (this.page == 0) {
            if (!StringUtils.isEmpty(this.configProvider.SHOP_NAV_FIRST_PAGE_ALERT_MSG)) {
                PlayerUtil.sendMessage(event.getWhoClicked(), this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_NAV_FIRST_PAGE_ALERT_MSG);
            }
        } else {
            --this.page;
            super.open(this.playerMenuUtility.getPlayerShopSearchResult());
        }
    }

    private void handleFirstPageClick(InventoryClickEvent event) {
        if (this.page == 0) {
            if (!StringUtils.isEmpty(this.configProvider.SHOP_NAV_FIRST_PAGE_ALERT_MSG)) {
                PlayerUtil.sendMessage(event.getWhoClicked(), this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_NAV_FIRST_PAGE_ALERT_MSG);
            }
        } else {
            this.page = 0;
            super.open(this.playerMenuUtility.getPlayerShopSearchResult());
        }
    }

    private void handleLastPageClick(InventoryClickEvent event) {
        int listSize = this.playerMenuUtility.getPlayerShopSearchResult().size();
        if (this.index + 1 < listSize) {
            double totalPages = listSize / 45;
            if (totalPages % 10.0 == 0.0) {
                this.page = (int)Math.floor(totalPages);
                Logger.logDebugInfo("Floor page value: " + this.page);
            } else {
                this.page = (int)Math.ceil(totalPages);
                Logger.logDebugInfo("Ceiling page value: " + this.page);
            }
            super.open(this.playerMenuUtility.getPlayerShopSearchResult());
        } else if (!StringUtils.isEmpty(this.configProvider.SHOP_NAV_LAST_PAGE_ALERT_MSG)) {
            PlayerUtil.sendMessage(event.getWhoClicked(), this.configProvider.PLUGIN_PREFIX + this.configProvider.SHOP_NAV_LAST_PAGE_ALERT_MSG);
        }
    }

    @Override
    public void setMenuItems(List<FoundShopItemModel> foundShops) {
        this.addMenuBottomBar();
        if (foundShops == null || foundShops.isEmpty()) {
            return;
        }
        int maxItemsPerPage = 45;
        for (int guiSlotCounter = 0; guiSlotCounter < maxItemsPerPage; ++guiSlotCounter) {
            this.index = maxItemsPerPage * this.page + guiSlotCounter;
            if (this.index >= foundShops.size()) break;
            FoundShopItemModel foundShop = foundShops.get(this.index);
            if (foundShop == null) continue;
            ItemStack item = this.createShopItem(foundShop);
            this.inventory.addItem(new ItemStack[]{item});
        }
    }

    @NotNull
    private ItemStack createShopItem(@NotNull FoundShopItemModel foundShop) {
        ItemStack item = new ItemStack(foundShop.getItem().getType(), foundShop.getItem().getAmount());
        ItemMeta meta = foundShop.getItem().getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(item.getType());
        }
        ArrayList<String> lore = new ArrayList<String>();
        this.addItemLore(lore, foundShop);
        meta.setLore(lore);
        this.setLocationData(meta, foundShop);
        if (foundShop.getItem().getItemMeta().hasCustomModelData()) {
            meta.setCustomModelData(Integer.valueOf(foundShop.getItem().getItemMeta().getCustomModelData()));
        }
        item.setItemMeta(meta);
        return item;
    }

    private void addItemLore(List<String> lore, FoundShopItemModel foundShop) {
        ItemMeta shopItemMeta = foundShop.getItem().getItemMeta();
        if (shopItemMeta != null && shopItemMeta.hasLore()) {
            for (String line : shopItemMeta.getLore()) {
                lore.add(ColorTranslator.translateColorCodes(line));
            }
        }
        for (String loreLine : this.configProvider.SHOP_GUI_ITEM_LORE) {
            if (loreLine.contains(ShopLorePlaceholdersEnum.NEAREST_WARP.value())) {
                String nearestWarpInfo = this.getNearestWarpInfo(foundShop);
                lore.add(ColorTranslator.translateColorCodes(loreLine.replace(ShopLorePlaceholdersEnum.NEAREST_WARP.value(), nearestWarpInfo)));
                continue;
            }
            lore.add(ColorTranslator.translateColorCodes(this.replaceLorePlaceholders(loreLine, foundShop)));
        }
        if (this.configProvider.TP_PLAYER_DIRECTLY_TO_SHOP && this.playerMenuUtility.getOwner().hasPermission(PlayerPermsEnum.FINDITEM_SHOPTP.value())) {
            lore.add(ColorTranslator.translateColorCodes(this.configProvider.CLICK_TO_TELEPORT_MSG));
        }
    }

    private String getNearestWarpInfo(FoundShopItemModel foundShop) {
        int nearestWarpMode = this.configProvider.NEAREST_WARP_MODE;
        switch (nearestWarpMode) {
            case 1: {
                if (!EssentialsXPlugin.isEnabled()) break;
                String nearestEWarp = EssentialWarpsUtil.findNearestWarp(foundShop.getShopLocation());
                return nearestEWarp != null && !StringUtils.isEmpty(nearestEWarp) ? nearestEWarp : this.configProvider.NO_WARP_NEAR_SHOP_ERROR_MSG;
            }
            case 2: {
                if (!PlayerWarpsPlugin.getIsEnabled()) break;
                Warp nearestPlayerWarp = PlayerWarpsUtil.findNearestWarp(foundShop.getShopLocation(), foundShop.getShopOwner());
                return nearestPlayerWarp != null ? nearestPlayerWarp.getWarpName() : this.configProvider.NO_WARP_NEAR_SHOP_ERROR_MSG;
            }
            case 3: {
                if (!WGPlugin.isEnabled()) break;
                String nearestWGRegion = new WGRegionUtils().findNearestWGRegion(foundShop.getShopLocation());
                return nearestWGRegion != null && !StringUtils.isEmpty(nearestWGRegion) ? nearestWGRegion : this.configProvider.NO_WG_REGION_NEAR_SHOP_ERROR_MSG;
            }
            case 4: {
                if (!ResidencePlugin.isEnabled()) break;
                ClaimedResidence nearestResidence = ResidenceUtils.findNearestResidence(foundShop.getShopLocation());
                return nearestResidence != null ? ResidenceUtils.getResidenceName(nearestResidence) : this.configProvider.NO_RESIDENCE_NEAR_SHOP_ERROR_MSG;
            }
            default: {
                Logger.logDebugInfo("Invalid value in 'nearest-warp-mode' in config.yml!");
            }
        }
        return this.configProvider.NO_WARP_NEAR_SHOP_ERROR_MSG;
    }

    private void setLocationData(ItemMeta meta, FoundShopItemModel foundShop) {
        NamespacedKey key = new NamespacedKey(FindItemAddOn.getInstance(), NAMEDSPACE_KEY_LOCATION_DATA);
        String locData = "";
        if (this.configProvider.TP_PLAYER_DIRECTLY_TO_SHOP) {
            Location shopLoc = foundShop.getShopLocation();
            locData = String.format("%s|||%d|||%d|||%d", shopLoc.getWorld().getName(), shopLoc.getBlockX(), shopLoc.getBlockY(), shopLoc.getBlockZ());
        } else if (this.configProvider.TP_PLAYER_TO_NEAREST_WARP) {
            locData = this.getNearestWarpInfo(foundShop);
        }
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)locData);
    }

    @NotNull
    private String replaceLorePlaceholders(String text, @NotNull FoundShopItemModel shop) {
        if ((text = text.replace(ShopLorePlaceholdersEnum.ITEM_PRICE.value(), this.formatNumber(shop.getShopPrice()))).contains(ShopLorePlaceholdersEnum.SHOP_STOCK.value())) {
            int stockOrSpace;
            int stock = shop.getRemainingStockOrSpace();
            String stockText = stock == -2 ? ((stockOrSpace = this.processUnknownStockSpace(shop)) == -2 ? SHOP_STOCK_UNKNOWN : (stockOrSpace == -1 ? SHOP_STOCK_UNLIMITED : String.valueOf(stockOrSpace))) : (stock == Integer.MAX_VALUE ? SHOP_STOCK_UNLIMITED : String.valueOf(stock));
            text = text.replace(ShopLorePlaceholdersEnum.SHOP_STOCK.value(), stockText);
        }
        if ((text = text.replace(ShopLorePlaceholdersEnum.SHOP_PER_ITEM_QTY.value(), String.valueOf(shop.getItem().getAmount()))).contains(ShopLorePlaceholdersEnum.SHOP_OWNER.value())) {
            OfflinePlayer shopOwner = Bukkit.getOfflinePlayer((UUID)shop.getShopOwner());
            String ownerName = shopOwner.getName() != null ? shopOwner.getName() : "Admin";
            text = text.replace(ShopLorePlaceholdersEnum.SHOP_OWNER.value(), ownerName);
        }
        if (text.contains(ShopLorePlaceholdersEnum.SHOP_LOCATION.value())) {
            Location loc = shop.getShopLocation();
            String locText = loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
            text = text.replace(ShopLorePlaceholdersEnum.SHOP_LOCATION.value(), locText);
        }
        text = text.replace(ShopLorePlaceholdersEnum.SHOP_WORLD.value(), Objects.requireNonNull(shop.getShopLocation().getWorld()).getName());
        text = text.replace(ShopLorePlaceholdersEnum.SHOP_VISITS.value(), String.valueOf(ShopSearchActivityStorageUtil.getPlayerVisitCount(shop.getShopLocation())));
        return text;
    }

    private int processUnknownStockSpace(FoundShopItemModel shop) {
        return FindItemAddOn.getQsApiInstance().processUnknownStockSpace(shop.getShopLocation(), shop.isToBuy());
    }

    private String replaceDelayPlaceholder(String tpDelayMsg, long delay) {
        return tpDelayMsg.replace("{DELAY}", String.valueOf(delay));
    }

    private String formatNumber(double number) {
        if (this.configProvider.SHOP_GUI_USE_SHORTER_CURRENCY_FORMAT) {
            if (number < 100000.0) {
                return String.format("%,.2f", number);
            }
            if (number < 1000000.0) {
                return String.format("%.2fK", number / 1000.0);
            }
            if (number < 1.0E9) {
                return String.format("%.2fM", number / 1000000.0);
            }
            if (number < 1.0E12) {
                return String.format("%.2fB", number / 1.0E9);
            }
            return String.format("%.2fT", number / 1.0E12);
        }
        return String.format("%,.2f", number);
    }

    private String replaceCustomCmdPlaceholders(String cmd, Player player, Location shopLoc) {
        return cmd.replace(CustomCmdPlaceholdersEnum.PLAYER_NAME.value(), player.getName()).replace(CustomCmdPlaceholdersEnum.SHOP_LOC_X.value(), Double.toString(shopLoc.getX())).replace(CustomCmdPlaceholdersEnum.SHOP_LOC_Y.value(), Double.toString(shopLoc.getY())).replace(CustomCmdPlaceholdersEnum.SHOP_LOC_Z.value(), Double.toString(shopLoc.getZ())).replace(CustomCmdPlaceholdersEnum.SHOP_WORLD.value(), shopLoc.getWorld().getName());
    }
}

