/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.models.enums;

import org.bukkit.entity.Player;

public enum PlayerPermsEnum {
    FINDITEM_ADMIN("finditem.admin"),
    FINDITEM_USE("finditem.use"),
    FINDITEM_HIDESHOP("finditem.hideshop"),
    FINDITEM_RELOAD("finditem.reload"),
    FINDITEM_RESTART("finditem.restart"),
    FINDITEM_SHOPTP("finditem.shoptp"),
    FINDITEM_SHOPTP_OWN("finditem.shoptp.own"),
    FINDITEM_SHOPTP_BYPASS_DELAY("finditem.shoptp-delay.bypass"),
    FINDITEM_SHOPTP_BYPASS_SAFETYCHECK("finditem.shoptp.bypass-safetycheck");

    private final String permName;

    private PlayerPermsEnum(String perm) {
        this.permName = perm;
    }

    public String value() {
        return this.permName;
    }

    public static boolean isAdmin(Player p) {
        return p.hasPermission(PlayerPermsEnum.FINDITEM_ADMIN.permName);
    }

    public static boolean hasShopTpDelayBypassPermOrAdmin(Player p) {
        return PlayerPermsEnum.isAdmin(p) || PlayerPermsEnum.hasShopTpDelayBypassPerm(p);
    }

    public static boolean hasShopTpDelayBypassPerm(Player p) {
        return p.hasPermission(PlayerPermsEnum.FINDITEM_SHOPTP_BYPASS_DELAY.permName);
    }

    public static boolean canPlayerTpToOwnShop(Player p) {
        return p.hasPermission(PlayerPermsEnum.FINDITEM_SHOPTP_OWN.permName);
    }
}

