/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.quickshop;

import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface QSApi<Q, S> {
    public static final String QS_TOTAL_SHOPS_ON_SERVER = "Total shops on server: ";
    public static final String QS_REMAINING_STOCK_OR_SPACE = "Remaining Stock/Space: ";

    public CompletableFuture<List<FoundShopItemModel>> findItemBasedOnTypeFromAllShops(ItemStack var1, boolean var2, Player var3);

    public CompletableFuture<List<FoundShopItemModel>> findItemBasedOnDisplayNameFromAllShops(String var1, boolean var2, Player var3);

    public CompletableFuture<List<FoundShopItemModel>> fetchAllItemsFromAllShops(boolean var1, Player var2);

    public Material getShopSignMaterial();

    public S findShopAtLocation(Block var1);

    public boolean isShopOwnerCommandRunner(Player var1, S var2);

    public List<S> getAllShops();

    public List<ShopSearchActivityModel> syncShopsListForStorage(List<ShopSearchActivityModel> var1);

    public void registerSubCommand();

    public UUID convertNameToUuid(String var1);

    public boolean isQSShopCacheImplemented();

    public int processUnknownStockSpace(Location var1, boolean var2);

    public static List<FoundShopItemModel> sortShops(int sortingMethod, List<FoundShopItemModel> shopsFoundList, boolean toBuy) {
        switch (sortingMethod) {
            case 1: {
                Collections.shuffle(shopsFoundList);
                break;
            }
            case 2: {
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getShopPrice));
                break;
            }
            case 3: {
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getRemainingStockOrSpace));
                Collections.reverse(shopsFoundList);
                break;
            }
            default: {
                Logger.logError("Invalid value in config.yml : 'shop-sorting-method'");
                Logger.logError("Defaulting to sorting by prices method");
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getShopPrice));
            }
        }
        return shopsFoundList;
    }

    public static int processStockOrSpace(int stockOrSpace) {
        if (stockOrSpace == -1) {
            return Integer.MAX_VALUE;
        }
        return stockOrSpace;
    }

    public static boolean isTimeDifferenceGreaterThanSeconds(@NotNull Date date1, @NotNull Date date2, int seconds) {
        Instant instant1 = date1.toInstant();
        Instant instant2 = date2.toInstant();
        Duration duration = Duration.between(instant1, instant2);
        long secondsDifference = Math.abs(duration.getSeconds());
        Logger.logDebugInfo("Difference: " + secondsDifference);
        return secondsDifference >= (long)seconds;
    }

    public static void logTimeTookMsg(Instant timeStart) {
        Logger.logInfo("Shop search took " + Duration.between(timeStart, Instant.now()).toMillis() + "ms");
    }
}

