/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.papermc.lib.PaperLib;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public final class PlayerUtil {
    public static void sendMessage(HumanEntity player, String message) {
        Bukkit.getScheduler().runTask(FindItemAddOn.getInstance(), () -> player.sendMessage(ColorTranslator.translateColorCodes(message)));
    }

    public static void teleport(Player player, Location locToTeleport) {
        PaperLib.teleportAsync((Entity)player, locToTeleport, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean hasPermission(Player player, String permission) {
        if (Bukkit.isPrimaryThread()) {
            return player.hasPermission(permission);
        }
        try {
            return (Boolean)Bukkit.getScheduler().callSyncMethod(FindItemAddOn.getInstance(), () -> player.hasPermission(permission)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Generated
    private PlayerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

