/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.async;

import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import lombok.Generated;

public final class VirtualThreadScheduler {
    private static final ExecutorService VIRTUAL_EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();

    public static Future<?> runTaskAsync(Runnable task) {
        return VIRTUAL_EXECUTOR.submit(task);
    }

    public static <T> Future<T> runTaskAsync(Callable<T> task) {
        return VIRTUAL_EXECUTOR.submit(task);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return CompletableFuture.supplyAsync(supplier, VIRTUAL_EXECUTOR);
    }

    public static void shutdown() {
        Logger.logInfo("Shutting down virtual thread executor...");
        VIRTUAL_EXECUTOR.shutdown();
    }

    @Generated
    private VirtualThreadScheduler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

