/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.models.HiddenShopModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.utils.async.VirtualThreadScheduler;
import io.myzticbean.finditemaddon.utils.json.ShopSearchActivityStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.maxgamer.quickshop.api.shop.Shop;

public final class HiddenShopStorageUtil {
    static List<HiddenShopModel> hiddenShopsList = new ArrayList<HiddenShopModel>();
    static final String HIDDEN_SHOP_STORAGE_JSON_FILE_NAME = "hiddenShops.json";

    @Deprecated(since="v2.0.7.7")
    public static void handleShopSearchVisibilityAsync(Shop shop, boolean hideShop) {
        Bukkit.getScheduler().runTaskAsynchronously(FindItemAddOn.getInstance(), () -> {
            Iterator<ShopSearchActivityModel> shopSearchActivityIterator = ShopSearchActivityStorageUtil.getGlobalShopsList().iterator();
            int i = 0;
            while (shopSearchActivityIterator.hasNext()) {
                Location shopLocation;
                ShopSearchActivityModel shopSearchActivity = shopSearchActivityIterator.next();
                if (shopSearchActivity.compareWith((shopLocation = shop.getLocation()).getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) {
                    ShopSearchActivityStorageUtil.getGlobalShopsList().get(i).setHiddenFromSearch(hideShop);
                    break;
                }
                ++i;
            }
        });
    }

    public static void handleShopSearchVisibilityAsync(com.ghostchu.quickshop.api.shop.Shop shop, boolean hideShop) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            Iterator<ShopSearchActivityModel> shopSearchActivityIterator = ShopSearchActivityStorageUtil.getGlobalShopsList().iterator();
            int i = 0;
            while (shopSearchActivityIterator.hasNext()) {
                Location shopLocation;
                ShopSearchActivityModel shopSearchActivity = shopSearchActivityIterator.next();
                if (shopSearchActivity.compareWith((shopLocation = shop.getLocation()).getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) {
                    ShopSearchActivityStorageUtil.getGlobalShopsList().get(i).setHiddenFromSearch(hideShop);
                    break;
                }
                ++i;
            }
        });
    }

    public static boolean isShopHidden(Shop shop) {
        for (ShopSearchActivityModel shopSearchActivity : ShopSearchActivityStorageUtil.getGlobalShopsList()) {
            Location shopLocation;
            if (!shopSearchActivity.compareWith((shopLocation = shop.getLocation()).getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            return shopSearchActivity.isHiddenFromSearch();
        }
        return false;
    }

    public static boolean isShopHidden(com.ghostchu.quickshop.api.shop.Shop shop) {
        for (ShopSearchActivityModel shopSearchActivity : ShopSearchActivityStorageUtil.getGlobalShopsList()) {
            Location shopLocation;
            if (!shopSearchActivity.compareWith((shopLocation = shop.getLocation()).getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            return shopSearchActivity.isHiddenFromSearch();
        }
        return false;
    }

    public static void loadHiddenShopsFromFile() {
        Gson gson = new Gson();
        File file = new File(FindItemAddOn.getInstance().getDataFolder().getAbsolutePath() + "/hiddenShops.json");
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                HiddenShopModel[] h = gson.fromJson((Reader)reader, HiddenShopModel[].class);
                hiddenShopsList = h != null ? new ArrayList<HiddenShopModel>(Arrays.asList(h)) : new ArrayList<HiddenShopModel>();
                Logger.logInfo("Loaded hidden shops from file");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveHiddenShopsToFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(FindItemAddOn.getInstance().getDataFolder().getAbsolutePath() + "/hiddenShops.json");
        file.getParentFile().mkdir();
        try {
            file.createNewFile();
            FileWriter writer = new FileWriter(file, false);
            gson.toJson(hiddenShopsList, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            Logger.logInfo("Saved hidden shops to file");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    private HiddenShopStorageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

