/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.log;

import io.myzticbean.finditemaddon.FindItemAddOn;
import lombok.Generated;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class Logger {
    public static final String QS_FIND_ITEM_ADD_ON = "[QuickShop-FindItemAddOn] ";
    public static final String QS_FIND_ITEM_ADD_ON_DEBUG_LOG = "[QuickShop-FindItemAddOn-DEBUG] ";

    public static void logDebugInfo(String text) {
        if (FindItemAddOn.getConfigProvider().isDebugModeEnabled()) {
            Bukkit.getLogger().warning(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON_DEBUG_LOG + Logger.getMainOrAsyncThreadLogText() + text));
        }
    }

    public static void logInfo(String text) {
        Bukkit.getLogger().info(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON + Logger.getMainOrAsyncThreadLogText() + text));
    }

    public static void logError(String text) {
        Bukkit.getLogger().severe(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON + text));
    }

    public static void logError(Exception e) {
        Bukkit.getLogger().severe(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON + e.getMessage()));
        e.printStackTrace();
    }

    public static void logError(String errorMessage, Exception e) {
        Bukkit.getLogger().severe(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON + errorMessage + ": " + e.getMessage()));
        e.printStackTrace();
    }

    public static void logWarning(String text) {
        Bukkit.getLogger().warning(ColorTranslator.translateColorCodes(QS_FIND_ITEM_ADD_ON + text));
    }

    private static String getMainOrAsyncThreadLogText() {
        return Bukkit.isPrimaryThread() ? "[main] " : "[" + Logger.isThreadVirtual() + Thread.currentThread().threadId() + "] ";
    }

    @NotNull
    private static String isThreadVirtual() {
        return Thread.currentThread().isVirtual() ? "vt-" : "t-";
    }

    @Generated
    private Logger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

