/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.warp;

import com.olziedev.playerwarps.api.PlayerWarpsAPI;
import com.olziedev.playerwarps.api.events.warp.PlayerWarpTeleportEvent;
import com.olziedev.playerwarps.api.warp.Warp;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.dependencies.PlayerWarpsPlugin;
import io.myzticbean.finditemaddon.utils.CommonUtils;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class PlayerWarpsUtil {
    @Nullable
    public static Warp findNearestWarp(Location shopLocation, UUID shopOwner) {
        Logger.logDebugInfo("Find nearest warp for shop location " + String.valueOf(shopLocation));
        List<Warp> playersWarps = PlayerWarpsPlugin.getAllWarps().stream().filter(warp -> warp.getWarpLocation().getWorld() != null).filter(warp -> warp.getWarpLocation().getWorld().equals(shopLocation.getWorld().getName())).toList();
        if (FindItemAddOn.getConfigProvider().ONLY_SHOW_PLAYER_OWNDED_WARPS) {
            playersWarps = playersWarps.stream().filter(warp -> warp.getWarpPlayer().getUUID().equals(shopOwner)).toList();
        }
        if (!playersWarps.isEmpty()) {
            TreeMap warpDistanceMap = new TreeMap();
            playersWarps.forEach(warp -> {
                Double distance3D = CommonUtils.calculateDistance3D(shopLocation.getX(), shopLocation.getY(), shopLocation.getZ(), warp.getWarpLocation().getX(), warp.getWarpLocation().getY(), warp.getWarpLocation().getZ());
                warpDistanceMap.put(distance3D, warp);
                Logger.logDebugInfo("Warp Distance: " + distance3D + " Warp Name: " + warp.getWarpName() + ", Warp World: " + warp.getWarpLocation().getWorld());
            });
            for (Map.Entry doubleWarpEntry : warpDistanceMap.entrySet()) {
                Double distance3D = (Double)doubleWarpEntry.getKey();
                Warp warp2 = (Warp)doubleWarpEntry.getValue();
                Logger.logDebugInfo("Warp: " + warp2.getWarpName() + " " + warp2.isWarpLocked() + " Distance in 3D: " + distance3D);
                if (FindItemAddOn.getConfigProvider().DO_NOT_TP_IF_PLAYER_WARP_LOCKED && ((Warp)doubleWarpEntry.getValue()).isWarpLocked() && distance3D > 500.0) continue;
                return (Warp)doubleWarpEntry.getValue();
            }
        }
        return null;
    }

    public static void executeWarpPlayer(Player player, String warpName) {
        PlayerWarpsAPI.getInstance(api -> {
            Warp playerWarp = api.getPlayerWarp(warpName, (CommandSender)player);
            if (playerWarp != null) {
                playerWarp.getWarpLocation().teleportWarp(player, PlayerWarpTeleportEvent.Cause.PLAYER_WARP_MENU);
            } else {
                Logger.logError("&e" + player.getName() + " &cis trying to teleport to a PlayerWarp that does not exist!");
            }
        });
    }

    @Generated
    private PlayerWarpsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

