/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.kodysimpson.simpapi.command.CommandList;
import me.kodysimpson.simpapi.command.SubCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class CoreCommand
extends Command {
    private final ArrayList<SubCommand> subcommands;
    private final CommandList commandList;

    public CoreCommand(String name, String description, String usageMessage, CommandList commandList, List<String> aliases, ArrayList<SubCommand> subCommands) {
        super(name, description, usageMessage, aliases);
        this.subcommands = subCommands;
        this.commandList = commandList;
    }

    public ArrayList<SubCommand> getSubCommands() {
        return this.subcommands;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (args.length > 0) {
            for (int i = 0; i < this.getSubCommands().size(); ++i) {
                if (!args[0].equalsIgnoreCase(this.getSubCommands().get(i).getName()) && (this.getSubCommands().get(i).getAliases() == null || !this.getSubCommands().get(i).getAliases().contains(args[0]))) continue;
                this.getSubCommands().get(i).perform(sender, args);
            }
        } else if (this.commandList == null) {
            sender.sendMessage("--------------------------------");
            for (SubCommand subcommand : this.subcommands) {
                sender.sendMessage(subcommand.getSyntax() + " - " + subcommand.getDescription());
            }
            sender.sendMessage("--------------------------------");
        } else {
            this.commandList.displayCommandList(sender, this.subcommands);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            ArrayList<String> subcommandsArguments = new ArrayList<String>();
            for (int i = 0; i < this.getSubCommands().size(); ++i) {
                subcommandsArguments.add(this.getSubCommands().get(i).getName());
            }
            return subcommandsArguments;
        }
        if (args.length >= 2) {
            for (int i = 0; i < this.getSubCommands().size(); ++i) {
                if (!args[0].equalsIgnoreCase(this.getSubCommands().get(i).getName())) continue;
                List<String> subCommandArgs = this.getSubCommands().get(i).getSubcommandArguments((Player)sender, args);
                if (subCommandArgs != null) {
                    return subCommandArgs;
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

