/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import me.kodysimpson.simpapi.config.Config;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final PrettyPrinter prettyPrinter = null;

    public static <T> T loadConfig(JavaPlugin plugin, Class<T> configClass) {
        T config = null;
        Config configAnnotation = configClass.getAnnotation(Config.class);
        if (configAnnotation == null) {
            plugin.getLogger().severe("The provided Configuration Java class was not annotated properly with @Config from SimpAPI. Therefore the config could not be loaded.");
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        } else {
            String fileName = configAnnotation.fileName();
            FileType fileType = configAnnotation.fileType();
            File messagesConfigFile = ConfigManager.getConfigFile(plugin, fileName, fileType);
            ObjectMapper mapper = ConfigManager.getObjectMapper(fileType);
            if (!messagesConfigFile.exists()) {
                try {
                    config = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                try {
                    mapper.writeValue(messagesConfigFile, config);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    plugin.getLogger().info("Attempting to read " + fileName + " config file.");
                    T t = mapper.readValue(messagesConfigFile, configClass);
                    ConfigManager.saveConfig(plugin, t);
                    return t;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return config;
    }

    public static void saveConfig(JavaPlugin plugin, Object configObject) {
        Config configAnnotation = configObject.getClass().getAnnotation(Config.class);
        if (configAnnotation == null) {
            plugin.getLogger().severe("The provided Configuration Java class was not annotated properly with @Config from SimpAPI. Therefore the config could not be saved.");
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        } else {
            String fileName = configAnnotation.fileName();
            FileType fileType = configAnnotation.fileType();
            plugin.getLogger().info("Attempting to save " + fileName + " config file.");
            File messagesConfigFile = ConfigManager.getConfigFile(plugin, fileName, fileType);
            ObjectMapper mapper = ConfigManager.getObjectMapper(fileType);
            try {
                mapper.writeValue(messagesConfigFile, configObject);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getConfigFile(JavaPlugin plugin, String fileName, FileType fileType) {
        switch (fileType) {
            case YAML: {
                return new File(plugin.getDataFolder(), fileName + ".yml");
            }
            case JSON: {
                return new File(plugin.getDataFolder(), fileName + ".json");
            }
        }
        return null;
    }

    private static ObjectMapper getObjectMapper(FileType fileType) {
        if (fileType == FileType.YAML) {
            return new ObjectMapper(new YAMLFactory()).configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true).configure(JsonParser.Feature.IGNORE_UNDEFINED, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return new ObjectMapper(new JsonFactory()).configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true).configure(JsonParser.Feature.IGNORE_UNDEFINED, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setDefaultPrettyPrinter(new DefaultPrettyPrinter());
    }

    public static enum FileType {
        JSON,
        YAML;

    }
}

