/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.conversations;

import java.util.Collections;
import java.util.Map;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import me.kodysimpson.simpapi.conversations.ArrayMatchCanceller;
import me.kodysimpson.simpapi.conversations.PrefixedAbandonedListener;
import me.kodysimpson.simpapi.conversations.ServerReloadListener;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.NullConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class ConversationStarter {
    @NotNull
    public static Conversation getForPlayer(@NotNull Plugin plugin, @NotNull Player player, @NotNull Prompt firstPrompt, @Nullable ConversationOptions options, @Nullable Map<Object, Object> initialData) {
        if (options == null) {
            options = ConversationOptions.DEFAULT_OPTIONS;
        }
        ConversationFactory factory = new ConversationFactory(plugin).withFirstPrompt(firstPrompt).withLocalEcho(options.localEcho).withPrefix(options.prefix).addConversationAbandonedListener((ConversationAbandonedListener)new PrefixedAbandonedListener(options.rawPrefix)).withConversationCanceller((ConversationCanceller)new ArrayMatchCanceller(options.escapeWordsCaseSensitive, options.escapeWords)).withInitialSessionData(initialData == null ? Collections.emptyMap() : initialData).withTimeout(options.timeOut);
        Conversation convo = factory.buildConversation((Conversable)player);
        new ServerReloadListener(plugin, convo);
        return convo;
    }

    public static final class ConversationOptions {
        private static final ConversationOptions DEFAULT_OPTIONS = new ConversationOptions(null, true, false, 60, false, "cancel", "exit", "quit", "escape", "done");
        public final ConversationPrefix prefix;
        public final boolean localEcho;
        public final boolean modal;
        public final int timeOut;
        public final boolean escapeWordsCaseSensitive;
        public final String[] escapeWords;
        private final String rawPrefix;

        public ConversationOptions(@Nullable String prefix, boolean localEcho, boolean modal, @Range(from=0L, to=0x7FFFFFFFL) int timeOut, boolean escapeWordsCaseSensitive, String ... escapeWords) {
            if (prefix == null) {
                this.rawPrefix = "";
                this.prefix = new NullConversationPrefix();
            } else {
                this.rawPrefix = ColorTranslator.translateColorCodes(prefix);
                this.prefix = context -> this.rawPrefix;
            }
            this.localEcho = localEcho;
            this.modal = modal;
            this.timeOut = timeOut;
            this.escapeWordsCaseSensitive = escapeWordsCaseSensitive;
            this.escapeWords = escapeWords == null || escapeWords.length < 1 ? new String[]{"cancel", "exit", "quit", "escape", "done"} : escapeWords;
        }
    }
}

