/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.conversations;

import java.util.Arrays;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.MessagePrompt;
import org.bukkit.conversations.Prompt;
import org.jetbrains.annotations.NotNull;

public class MultilineMessage
extends MessagePrompt {
    private final Prompt end;
    private final String[] messages;

    public MultilineMessage(Prompt end, String ... messages) {
        if (messages == null || messages.length == 0) {
            throw new IllegalStateException("Invalid multiline message");
        }
        this.end = end;
        this.messages = messages;
    }

    @NotNull
    public String getPromptText(@NotNull ConversationContext context) {
        return ColorTranslator.translateColorCodes(this.messages[0]);
    }

    protected Prompt getNextPrompt(@NotNull ConversationContext context) {
        if (this.messages.length == 1) {
            return this.end;
        }
        return new MultilineMessage(this.end, Arrays.copyOfRange(this.messages, 1, this.messages.length));
    }
}

