/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.conversations;

import org.bukkit.Bukkit;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class ServerReloadListener
implements Listener {
    final ServerReloadCanceller canceller;
    private final Class<? extends Plugin> pluginClazz;

    ServerReloadListener(Plugin plugin, Conversation convo) {
        this.pluginClazz = plugin.getClass();
        this.canceller = new ServerReloadCanceller();
        convo.getCancellers().add(this.canceller);
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onReload(PluginDisableEvent event) {
        if (event.getPlugin().getClass() != this.pluginClazz) {
            return;
        }
        this.canceller.forceAbandon();
    }

    static final class ServerReloadCanceller
    implements ConversationCanceller {
        private Conversation conversation;

        ServerReloadCanceller() {
        }

        public void setConversation(@NotNull Conversation conversation) {
            this.conversation = conversation;
        }

        public boolean cancelBasedOnInput(@NotNull ConversationContext context, @NotNull String input) {
            return false;
        }

        public ConversationCanceller clone() {
            return this;
        }

        void forceAbandon() {
            this.conversation.abandon(new ConversationAbandonedEvent(this.conversation, (ConversationCanceller)this));
        }
    }
}

