/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.heads;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullCreator {
    @Deprecated
    public static ItemStack itemFromName(String name) {
        ItemStack item = SkullCreator.getPlayerSkullItem();
        return SkullCreator.itemWithName(item, name);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack item, String name) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(name, "name");
        return Bukkit.getUnsafe().modifyItemStack(item, "{SkullOwner:\"" + name + "\"}");
    }

    public static ItemStack itemFromUuid(UUID id) {
        ItemStack item = SkullCreator.getPlayerSkullItem();
        return SkullCreator.itemWithUuid(item, id);
    }

    public static ItemStack itemWithUuid(ItemStack item, UUID id) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        Objects.requireNonNull(meta).setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemFromUrl(String url) {
        ItemStack item = SkullCreator.getPlayerSkullItem();
        return SkullCreator.itemWithUrl(item, url);
    }

    public static ItemStack itemWithUrl(ItemStack item, String url) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(url, "url");
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemFromBase64(String base64) {
        ItemStack item = SkullCreator.getPlayerSkullItem();
        return SkullCreator.itemWithBase64(item, base64);
    }

    public static ItemStack itemWithBase64(ItemStack item, String base64) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(base64, "base64");
        UUID hashAsId = new UUID(base64.hashCode(), base64.hashCode());
        return Bukkit.getUnsafe().modifyItemStack(item, "{SkullOwner:{Id:\"" + hashAsId + "\",Properties:{textures:[{Value:\"" + base64 + "\"}]}}}");
    }

    @Deprecated
    public static void blockWithName(Block block, String name) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(name, "name");
        SkullCreator.setBlockType(block);
        ((Skull)block.getState()).setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
    }

    public static void blockWithUuid(Block block, UUID id) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(id, "id");
        SkullCreator.setBlockType(block);
        ((Skull)block.getState()).setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
    }

    public static void blockWithUrl(Block block, String url) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(url, "url");
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(url));
    }

    public static void blockWithBase64(Block block, String base64) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(base64, "base64");
        UUID hashAsId = new UUID(base64.hashCode(), base64.hashCode());
        String args = String.format("%d %d %d %s", block.getX(), block.getY(), block.getZ(), "{Owner:{Id:\"" + hashAsId + "\",Properties:{textures:[{Value:\"" + base64 + "\"}]}}}");
        if (SkullCreator.newerApi()) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("data merge block " + args));
        } else {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("blockdata " + args));
        }
    }

    private static boolean newerApi() {
        try {
            Material.valueOf((String)"PLAYER_HEAD");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static ItemStack getPlayerSkullItem() {
        if (SkullCreator.newerApi()) {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
    }

    private static void setBlockType(Block block) {
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException e) {
            block.setType(Material.valueOf((String)"SKULL"), false);
        }
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }
}

