/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.input;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatInput {
    public static void requestInput(final Plugin plugin, Player player, final String prompt, final Predicate<String> validator, final Consumer<String> onInput, final Runnable onCancel) {
        ConversationFactory factory = new ConversationFactory(plugin).withModality(true).withLocalEcho(false).withPrefix(context -> "\u00a76\u00a7l[Input] \u00a7r").withFirstPrompt((Prompt)new StringPrompt(){

            public String getPromptText(ConversationContext context) {
                return prompt;
            }

            public Prompt acceptInput(ConversationContext context, String input) {
                if (input.equalsIgnoreCase("cancel")) {
                    context.getForWhom().sendRawMessage("\u00a7cInput cancelled.");
                    if (onCancel != null) {
                        plugin.getServer().getScheduler().runTask(plugin, onCancel);
                    }
                    return END_OF_CONVERSATION;
                }
                if (validator.test(input)) {
                    plugin.getServer().getScheduler().runTask(plugin, () -> onInput.accept(input));
                    return END_OF_CONVERSATION;
                }
                return this;
            }
        }).withEscapeSequence("cancel").thatExcludesNonPlayersWithMessage("Only players can provide input!").addConversationAbandonedListener(event -> {
            if (!event.gracefulExit() && onCancel != null) {
                plugin.getServer().getScheduler().runTask(plugin, onCancel);
            }
        });
        factory.buildConversation((Conversable)player).begin();
    }

    public static void requestInput(Plugin plugin, Player player, String prompt, Consumer<String> onInput) {
        ChatInput.requestInput(plugin, player, prompt, input -> true, onInput, null);
    }

    public static void requestNumericInput(Plugin plugin, Player player, String prompt, Consumer<Double> onInput) {
        ChatInput.requestInput(plugin, player, prompt, input -> {
            try {
                Double.parseDouble(input);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, input -> onInput.accept(Double.parseDouble(input)), null);
    }
}

