/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.menu;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import me.kodysimpson.simpapi.exceptions.MenuManagerException;
import me.kodysimpson.simpapi.exceptions.MenuManagerNotSetupException;
import me.kodysimpson.simpapi.menu.MenuManager;
import me.kodysimpson.simpapi.menu.PlayerMenuUtility;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public abstract class Menu
implements InventoryHolder {
    protected PlayerMenuUtility playerMenuUtility;
    protected Player player;
    protected Inventory inventory;
    protected ItemStack FILLER_GLASS = this.makeItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);

    public Menu(PlayerMenuUtility playerMenuUtility) {
        this.playerMenuUtility = playerMenuUtility;
        this.player = playerMenuUtility.getOwner();
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract boolean cancelAllClicks();

    public abstract void handleMenu(InventoryClickEvent var1) throws MenuManagerNotSetupException, MenuManagerException;

    public abstract void setMenuItems();

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems();
        this.playerMenuUtility.getOwner().openInventory(this.inventory);
        this.playerMenuUtility.pushMenu(this);
    }

    public void back() throws MenuManagerException, MenuManagerNotSetupException {
        MenuManager.openMenu(this.playerMenuUtility.lastMenu().getClass(), this.playerMenuUtility.getOwner());
    }

    protected void reloadItems() {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, null);
        }
        this.setMenuItems();
    }

    protected void reload() throws MenuManagerException, MenuManagerNotSetupException {
        this.player.closeInventory();
        MenuManager.openMenu(this.getClass(), this.player);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void setFillerGlass() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, this.FILLER_GLASS);
        }
    }

    public void setFillerGlass(ItemStack itemStack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, itemStack);
        }
    }

    public ItemStack makeItem(Material material, String displayName, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(displayName);
        itemMeta.setLore(Arrays.stream(lore).map(ColorTranslator::translateColorCodes).collect(Collectors.toList()));
        item.setItemMeta(itemMeta);
        return item;
    }

    public void handleMenuClose() {
    }
}

