/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.menu;

import java.util.HashMap;
import java.util.List;
import me.kodysimpson.simpapi.menu.Menu;
import me.kodysimpson.simpapi.menu.PlayerMenuUtility;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class PaginatedMenu
extends Menu {
    protected List<Object> data;
    protected int page = 0;
    protected int maxItemsPerPage = 28;
    private List<ItemStack> cachedItems;

    public PaginatedMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    public abstract List<ItemStack> dataToItems();

    @Nullable
    public abstract HashMap<Integer, ItemStack> getCustomMenuBorderItems();

    protected void addMenuBorder() {
        int i;
        this.inventory.setItem(47, this.makeItem(Material.DARK_OAK_BUTTON, ChatColor.GREEN + "First Page", new String[0]));
        this.inventory.setItem(48, this.makeItem(Material.DARK_OAK_BUTTON, ChatColor.GREEN + "Previous", new String[0]));
        this.inventory.setItem(49, this.makeItem(Material.BARRIER, ChatColor.DARK_RED + "Close", new String[0]));
        this.inventory.setItem(50, this.makeItem(Material.DARK_OAK_BUTTON, ChatColor.GREEN + "Next", new String[0]));
        this.inventory.setItem(51, this.makeItem(Material.DARK_OAK_BUTTON, ChatColor.GREEN + "Last Page", new String[0]));
        for (i = 0; i < 10; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, this.FILLER_GLASS);
        }
        this.inventory.setItem(17, this.FILLER_GLASS);
        this.inventory.setItem(18, this.FILLER_GLASS);
        this.inventory.setItem(26, this.FILLER_GLASS);
        this.inventory.setItem(27, this.FILLER_GLASS);
        this.inventory.setItem(35, this.FILLER_GLASS);
        this.inventory.setItem(36, this.FILLER_GLASS);
        for (i = 44; i < 54; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, this.FILLER_GLASS);
        }
        if (this.getCustomMenuBorderItems() != null) {
            this.getCustomMenuBorderItems().forEach((integer, itemStack) -> this.inventory.setItem(integer.intValue(), itemStack));
        }
    }

    protected List<ItemStack> getItems() {
        if (this.cachedItems == null) {
            this.cachedItems = this.dataToItems();
        }
        return this.cachedItems;
    }

    protected void invalidateCache() {
        this.cachedItems = null;
    }

    @Override
    public void setMenuItems() {
        int index;
        this.addMenuBorder();
        List<ItemStack> items = this.getItems();
        int slot = 10;
        for (int i = 0; i < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i) < items.size(); ++i) {
            if (slot % 9 == 8) {
                slot += 2;
            }
            this.inventory.setItem(slot, items.get(index));
            ++slot;
        }
    }

    public boolean prevPage() {
        if (this.page == 0) {
            return false;
        }
        --this.page;
        this.reloadItems();
        return true;
    }

    public boolean nextPage() {
        int totalItems = this.getItems().size();
        int lastPageNumber = (totalItems - 1) / this.maxItemsPerPage;
        if (this.page < lastPageNumber) {
            ++this.page;
            this.reloadItems();
            return true;
        }
        return false;
    }

    public int getMaxItemsPerPage() {
        return this.maxItemsPerPage;
    }

    public int getCurrentPage() {
        return this.page + 1;
    }

    public int getTotalPages() {
        return (this.getItems().size() - 1) / this.maxItemsPerPage + 1;
    }

    @Override
    public void open() {
        this.invalidateCache();
        super.open();
    }

    public void refreshData() {
        this.invalidateCache();
        this.reloadItems();
    }

    public boolean firstPage() {
        if (this.page == 0) {
            return false;
        }
        this.page = 0;
        this.reloadItems();
        return true;
    }

    public boolean lastPage() {
        int lastPageNum = (this.getItems().size() - 1) / this.maxItemsPerPage;
        if (this.page == lastPageNum) {
            return false;
        }
        this.page = lastPageNum;
        this.reloadItems();
        return true;
    }
}

