/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.region;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Region {
    private Location corner1 = null;
    private Location corner2 = null;

    public boolean isSet() {
        return this.corner1 != null && this.corner2 != null;
    }

    public World getWorld() {
        return this.corner1.getWorld();
    }

    public boolean isIn(Location loc) {
        double xMin = Math.min(this.corner1.getX(), this.corner2.getX());
        double xMax = Math.max(this.corner1.getX(), this.corner2.getX());
        double yMin = Math.min(this.corner1.getY(), this.corner2.getY());
        double yMax = Math.max(this.corner1.getY(), this.corner2.getY());
        double zMin = Math.min(this.corner1.getZ(), this.corner2.getZ());
        double zMax = Math.max(this.corner1.getZ(), this.corner2.getZ());
        return (double)loc.getBlockX() >= xMin && (double)loc.getBlockX() <= xMax && (double)loc.getBlockY() >= yMin && (double)loc.getBlockY() <= yMax && (double)loc.getBlockZ() >= zMin && (double)loc.getBlockZ() <= zMax;
    }

    public int getTotalBlockSize() {
        return (int)(this.getHeight() * this.getXWidth() * this.getZWidth());
    }

    public double getHeight() {
        double yMin = Math.min(this.corner1.getY(), this.corner2.getY());
        double yMax = Math.max(this.corner1.getY(), this.corner2.getY());
        return yMax - yMin + 1.0;
    }

    public double getXWidth() {
        double xMin = Math.min(this.corner1.getX(), this.corner2.getX());
        double xMax = Math.max(this.corner1.getX(), this.corner2.getX());
        return xMax - xMin + 1.0;
    }

    public double getZWidth() {
        double zMin = Math.min(this.corner1.getZ(), this.corner2.getZ());
        double zMax = Math.max(this.corner1.getZ(), this.corner2.getZ());
        return zMax - zMin + 1.0;
    }

    public List<Block> blockList(World world) {
        double xMin = Math.min(this.corner1.getX(), this.corner2.getX());
        double xMax = Math.max(this.corner1.getX(), this.corner2.getX());
        double yMin = Math.min(this.corner1.getY(), this.corner2.getY());
        double yMax = Math.max(this.corner1.getY(), this.corner2.getY());
        double zMin = Math.min(this.corner1.getZ(), this.corner2.getZ());
        double zMax = Math.max(this.corner1.getZ(), this.corner2.getZ());
        ArrayList<Block> bL = new ArrayList<Block>(this.getTotalBlockSize());
        for (double x = xMin; x <= xMax; x += 1.0) {
            for (double y = yMin; y <= yMax; y += 1.0) {
                for (double z = zMin; z <= zMax; z += 1.0) {
                    Block b = world.getBlockAt((int)x, (int)y, (int)z);
                    bL.add(b);
                }
            }
        }
        return bL;
    }

    public boolean isPlayerIn(Player player) {
        return this.isIn(player.getLocation());
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Block block : this.blockList(this.corner1.getWorld())) {
            entities.addAll(block.getWorld().getNearbyEntities(block.getLocation(), 1.0, 1.0, 1.0));
        }
        return entities;
    }

    public Location getCorner1() {
        return this.corner1;
    }

    public Location getCorner2() {
        return this.corner2;
    }

    public void setCorner1(Location corner1) {
        this.corner1 = corner1;
    }

    public void setCorner2(Location corner2) {
        this.corner2 = corner2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region other = (Region)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Location this$corner1 = this.getCorner1();
        Location other$corner1 = other.getCorner1();
        if (this$corner1 == null ? other$corner1 != null : !this$corner1.equals(other$corner1)) {
            return false;
        }
        Location this$corner2 = this.getCorner2();
        Location other$corner2 = other.getCorner2();
        return !(this$corner2 == null ? other$corner2 != null : !this$corner2.equals(other$corner2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Region;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Location $corner1 = this.getCorner1();
        result = result * 59 + ($corner1 == null ? 43 : $corner1.hashCode());
        Location $corner2 = this.getCorner2();
        result = result * 59 + ($corner2 == null ? 43 : $corner2.hashCode());
        return result;
    }

    public String toString() {
        return "Region(corner1=" + this.getCorner1() + ", corner2=" + this.getCorner2() + ")";
    }
}

