/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.handlers.gui;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.handlers.gui.PlayerMenuUtility;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.jetbrains.annotations.NotNull;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    protected PlayerMenuUtility playerMenuUtility;
    protected ItemStack GUI_FILLER_ITEM;

    protected Menu(PlayerMenuUtility playerMenuUtility) {
        this.playerMenuUtility = playerMenuUtility;
        assert (FindItemAddOn.getConfigProvider().SHOP_GUI_FILLER_ITEM != null);
        Material fillerMaterial = Material.getMaterial((String)FindItemAddOn.getConfigProvider().SHOP_GUI_FILLER_ITEM);
        if (fillerMaterial == null) {
            fillerMaterial = Material.GRAY_STAINED_GLASS_PANE;
        }
        if (!fillerMaterial.isAir()) {
            this.GUI_FILLER_ITEM = new ItemStack(fillerMaterial);
            ItemMeta fillerItemItemMeta = this.GUI_FILLER_ITEM.getItemMeta();
            assert (fillerItemItemMeta != null);
            fillerItemItemMeta.setDisplayName(" ");
            if (!StringUtils.isEmpty(FindItemAddOn.getConfigProvider().SHOP_GUI_FILLER_ITEM_CMD)) {
                try {
                    fillerItemItemMeta.setCustomModelData(Integer.valueOf(Integer.parseInt(FindItemAddOn.getConfigProvider().SHOP_GUI_FILLER_ITEM_CMD)));
                    if (this.checkServerVersionIs_1_21_5_OrAbove()) {
                        CustomModelDataComponent customModelDataComponent = fillerItemItemMeta.getCustomModelDataComponent();
                        customModelDataComponent.setFloats(List.of(Float.valueOf(Float.parseFloat(FindItemAddOn.getConfigProvider().SHOP_GUI_FILLER_ITEM_CMD))));
                        fillerItemItemMeta.setCustomModelDataComponent(customModelDataComponent);
                    }
                }
                catch (Exception e) {
                    Logger.logError("Error setting custom model data", e);
                }
            }
            this.GUI_FILLER_ITEM.setItemMeta(fillerItemItemMeta);
        }
    }

    private boolean checkServerVersionIs_1_21_5_OrAbove() {
        String serverVersionString = Bukkit.getVersion();
        Logger.logDebugInfo("Full Server Version for check: " + serverVersionString);
        Pattern pattern = Pattern.compile("\\(MC: ([\\d\\.]+)\\)");
        Matcher matcher = pattern.matcher(serverVersionString);
        if (matcher.find()) {
            String mcVersionStr = matcher.group(1);
            Logger.logDebugInfo("Extracted MC Version: " + mcVersionStr);
            String[] versionParts = mcVersionStr.split("\\.");
            if (versionParts.length >= 2) {
                try {
                    String patchStr;
                    int major = Integer.parseInt(versionParts[0]);
                    int minor = Integer.parseInt(versionParts[1]);
                    int patch = 0;
                    if (versionParts.length >= 3 && !(patchStr = versionParts[2].replaceAll("[^0-9]", "")).isEmpty()) {
                        patch = Integer.parseInt(patchStr);
                    }
                    boolean TARGET_MAJOR = true;
                    int TARGET_MINOR = 21;
                    int TARGET_PATCH = 5;
                    if (major > 1) {
                        return true;
                    }
                    if (major == 1) {
                        if (minor > 21) {
                            return true;
                        }
                        if (minor == 21) {
                            return patch >= 5;
                        }
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    Logger.logDebugInfo("Failed to parse MC version parts from: '" + mcVersionStr + "': " + e.getMessage());
                    return false;
                }
            }
            Logger.logDebugInfo("Could not parse MC version string '" + mcVersionStr + "' into at least major.minor parts.");
            return false;
        }
        Logger.logDebugInfo("Could not find MC version pattern '(MC: ...)' in server version string: '" + serverVersionString + "'. Assuming older version or unable to determine.");
        return false;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems(List<FoundShopItemModel> var1);

    public void open(List<FoundShopItemModel> foundShops) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems(foundShops);
        this.playerMenuUtility.getOwner().openInventory(this.inventory);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

