/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.quickshop;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface QSApi<QSType, Shop> {
    public static final String QS_TOTAL_SHOPS_ON_SERVER = "Total shops on server: ";
    public static final String QS_REMAINING_STOCK_OR_SPACE = "Remaining Stock/Space: ";

    public List<FoundShopItemModel> findItemBasedOnTypeFromAllShops(ItemStack var1, boolean var2, Player var3);

    public List<FoundShopItemModel> findItemBasedOnDisplayNameFromAllShops(String var1, boolean var2, Player var3);

    public List<FoundShopItemModel> fetchAllItemsFromAllShops(boolean var1, Player var2);

    public Material getShopSignMaterial();

    public Shop findShopAtLocation(Block var1);

    public boolean isShopOwnerCommandRunner(Player var1, Shop var2);

    public List<Shop> getAllShops();

    public List<ShopSearchActivityModel> syncShopsListForStorage(List<ShopSearchActivityModel> var1);

    public void registerSubCommand();

    public UUID convertNameToUuid(String var1);

    public boolean isQSShopCacheImplemented();

    public int processUnknownStockSpace(Location var1, boolean var2);

    public static List<FoundShopItemModel> sortShops(int sortingMethod, List<FoundShopItemModel> shopsFoundList, boolean toBuy) {
        switch (sortingMethod) {
            case 1: {
                Collections.shuffle(shopsFoundList);
                break;
            }
            case 2: {
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getShopPrice));
                break;
            }
            case 3: {
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getRemainingStockOrSpace));
                Collections.reverse(shopsFoundList);
                break;
            }
            default: {
                Logger.logError("Invalid value in config.yml : 'shop-sorting-method'");
                Logger.logError("Defaulting to sorting by prices method");
                shopsFoundList.sort(Comparator.comparing(FoundShopItemModel::getShopPrice));
            }
        }
        if (FindItemAddOn.getConfigProvider().DEBUG_MODE) {
            shopsFoundList.forEach(foundShopItem -> Logger.logDebugInfo(QS_REMAINING_STOCK_OR_SPACE + foundShopItem.getRemainingStockOrSpace()));
        }
        return shopsFoundList;
    }

    public static int processStockOrSpace(int stockOrSpace) {
        if (stockOrSpace == -1) {
            return Integer.MAX_VALUE;
        }
        return stockOrSpace;
    }

    public static boolean isTimeDifferenceGreaterThanSeconds(Date date1, Date date2, int seconds) {
        Instant instant1 = date1.toInstant();
        Instant instant2 = date2.toInstant();
        Duration duration = Duration.between(instant1, instant2);
        long secondsDifference = Math.abs(duration.getSeconds());
        Logger.logDebugInfo("Difference: " + secondsDifference);
        return secondsDifference >= (long)seconds;
    }

    public static void logTimeTookMsg(Instant timeStart) {
        Logger.logInfo("Shop search took " + Duration.between(timeStart, Instant.now()).toMillis() + "ms");
    }
}

