/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.quickshop.impl;

import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import com.ghostchu.quickshop.QuickShop;
import com.ghostchu.quickshop.QuickShopBukkit;
import com.ghostchu.quickshop.api.QuickShopAPI;
import com.ghostchu.quickshop.api.command.CommandContainer;
import com.ghostchu.quickshop.api.command.CommandHandler;
import com.ghostchu.quickshop.api.economy.AbstractEconomy;
import com.ghostchu.quickshop.api.obj.QUser;
import com.ghostchu.quickshop.api.shop.Shop;
import com.ghostchu.quickshop.api.shop.permission.BuiltInShopPermission;
import com.ghostchu.quickshop.database.DataTables;
import com.ghostchu.quickshop.util.Util;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.commands.quickshop.subcommands.FindItemCmdHikariImpl;
import io.myzticbean.finditemaddon.models.CachedShop;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.PlayerShopVisitModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.quickshop.QSApi;
import io.myzticbean.finditemaddon.utils.json.HiddenShopStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QSHikariAPIHandler
implements QSApi<QuickShop, Shop> {
    public static final String IS_MAIN_THREAD = "Is MAIN Thread? ";
    private final QuickShopAPI api = QuickShopAPI.getInstance();
    private final String pluginVersion = Bukkit.getPluginManager().getPlugin("QuickShop-Hikari").getDescription().getVersion();
    private final ConcurrentMap<Long, CachedShop> shopCache;
    private final int SHOP_CACHE_TIMEOUT_SECONDS = 300;
    private final boolean isQSHikariShopCacheImplemented;

    public QSHikariAPIHandler() {
        Logger.logInfo("Initializing Shop caching");
        this.shopCache = new ConcurrentHashMap<Long, CachedShop>();
        this.isQSHikariShopCacheImplemented = this.checkIfQSHikariShopCacheImplemented();
    }

    @Override
    public List<FoundShopItemModel> findItemBasedOnTypeFromAllShops(ItemStack item, boolean toBuy, Player searchingPlayer) {
        Logger.logDebugInfo(IS_MAIN_THREAD + Bukkit.isPrimaryThread());
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        List<Shop> allShops = this.fetchAllShopsFromQS();
        Logger.logDebugInfo("Total shops on server: " + allShops.size());
        for (Shop shopIterator : allShops) {
            if (!shopIterator.playerAuthorize(searchingPlayer.getUniqueId(), BuiltInShopPermission.SEARCH) || FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shopIterator.getLocation().getWorld()) || !shopIterator.getItem().getType().equals((Object)item.getType()) || !(toBuy ? shopIterator.isSelling() : shopIterator.isBuying()) || HiddenShopStorageUtil.isShopHidden(shopIterator)) continue;
            this.processPotentialShopMatchAndAddToFoundList(toBuy, shopIterator, shopsFoundList, searchingPlayer);
        }
        List<FoundShopItemModel> sortedShops = QSHikariAPIHandler.handleShopSorting(toBuy, shopsFoundList);
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    private static boolean isOwnerHavingEnoughBalance(@NotNull Shop shop) {
        if (shop.getOwner().getUniqueIdOptional().isEmpty()) {
            return true;
        }
        double price = shop.getPrice();
        double itemAmount = shop.getItem().getAmount();
        double pricePerTransaction = price * itemAmount;
        AbstractEconomy economy = QSHikariAPIHandler.getQuickShop().getEconomy();
        QUser qUser = shop.getOwner();
        UUID uuid = qUser.getUniqueIdIfRealPlayer().orElse(null);
        if (Objects.isNull(uuid)) {
            return true;
        }
        OfflinePlayer bukkitPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        World world = bukkitPlayer.getLocation().getWorld();
        if (Objects.isNull(world)) {
            Logger.logError("Shop owner hasn't played before ever in the server (?) - ShopInfo: " + shop.getOwner().getUsername());
            return true;
        }
        String currency = shop.getCurrency();
        return economy.getBalance(qUser, world, currency) >= pricePerTransaction;
    }

    private static QuickShop getQuickShop() {
        return ((QuickShopBukkit)QuickShopAPI.getPluginInstance()).getQuickShop();
    }

    @NotNull
    static List<FoundShopItemModel> handleShopSorting(boolean toBuy, @NotNull List<FoundShopItemModel> shopsFoundList) {
        if (!shopsFoundList.isEmpty()) {
            int sortingMethod = 2;
            try {
                sortingMethod = FindItemAddOn.getConfigProvider().SHOP_SORTING_METHOD;
            }
            catch (Exception e) {
                Logger.logError("Invalid value in config.yml : 'shop-sorting-method'");
                Logger.logError("Defaulting to sorting by prices method");
            }
            return QSApi.sortShops(sortingMethod, shopsFoundList, toBuy);
        }
        return shopsFoundList;
    }

    @Override
    public List<FoundShopItemModel> findItemBasedOnDisplayNameFromAllShops(String displayName, boolean toBuy, Player searchingPlayer) {
        Logger.logDebugInfo(IS_MAIN_THREAD + Bukkit.isPrimaryThread());
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        List<Shop> allShops = this.fetchAllShopsFromQS();
        Logger.logDebugInfo("Total shops on server: " + allShops.size());
        for (Shop shopIterator : allShops) {
            if (!shopIterator.playerAuthorize(searchingPlayer.getUniqueId(), BuiltInShopPermission.SEARCH) || FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shopIterator.getLocation().getWorld()) || !shopIterator.getItem().hasItemMeta() || !Objects.requireNonNull(shopIterator.getItem().getItemMeta()).hasDisplayName() || !shopIterator.getItem().getItemMeta().getDisplayName().toLowerCase().contains(displayName.toLowerCase()) || !(toBuy ? shopIterator.isSelling() : shopIterator.isBuying()) || HiddenShopStorageUtil.isShopHidden(shopIterator)) continue;
            this.processPotentialShopMatchAndAddToFoundList(toBuy, shopIterator, shopsFoundList, searchingPlayer);
        }
        List<FoundShopItemModel> sortedShops = QSHikariAPIHandler.handleShopSorting(toBuy, shopsFoundList);
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    @Override
    public List<FoundShopItemModel> fetchAllItemsFromAllShops(boolean toBuy, Player searchingPlayer) {
        Logger.logDebugInfo(IS_MAIN_THREAD + Bukkit.isPrimaryThread());
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        List<Shop> allShops = this.fetchAllShopsFromQS();
        Logger.logDebugInfo("Total shops on server: " + allShops.size());
        for (Shop shopIterator : allShops) {
            if (!shopIterator.playerAuthorize(searchingPlayer.getUniqueId(), BuiltInShopPermission.SEARCH) || FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shopIterator.getLocation().getWorld()) || !(toBuy ? shopIterator.isSelling() : shopIterator.isBuying()) || HiddenShopStorageUtil.isShopHidden(shopIterator)) continue;
            this.processPotentialShopMatchAndAddToFoundList(toBuy, shopIterator, shopsFoundList, searchingPlayer);
        }
        List<FoundShopItemModel> sortedShops = new ArrayList<FoundShopItemModel>(shopsFoundList);
        if (!shopsFoundList.isEmpty()) {
            int sortingMethod = 1;
            sortedShops = QSApi.sortShops(sortingMethod, shopsFoundList, toBuy);
        }
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    private List<Shop> fetchAllShopsFromQS() {
        List<Shop> allShops = FindItemAddOn.getConfigProvider().SEARCH_LOADED_SHOPS_ONLY ? new ArrayList<Shop>(this.api.getShopManager().getLoadedShops()) : this.getAllShops();
        return allShops;
    }

    @Override
    public Material getShopSignMaterial() {
        return Util.getSignMaterial();
    }

    @Override
    public Shop findShopAtLocation(Block block) {
        Block secondHalf;
        Location loc = block.getLocation();
        Shop shop = this.api.getShopManager().getShopIncludeAttached(loc);
        if (shop == null && block.getType() == Material.CHEST && (secondHalf = Util.getSecondHalf((Block)block)) != null) {
            shop = this.api.getShopManager().getShopIncludeAttached(secondHalf.getLocation());
        }
        return shop;
    }

    @Override
    public boolean isShopOwnerCommandRunner(Player player, Shop shop) {
        Logger.logDebugInfo("Shop owner: " + String.valueOf(shop.getOwner()) + " | Player: " + String.valueOf(player.getUniqueId()));
        return shop.getOwner().getUniqueId().toString().equalsIgnoreCase(player.getUniqueId().toString());
    }

    @Override
    public List<Shop> getAllShops() {
        return this.api.getShopManager().getAllShops();
    }

    @Override
    public List<ShopSearchActivityModel> syncShopsListForStorage(List<ShopSearchActivityModel> globalShopsList) {
        long start = System.currentTimeMillis();
        ArrayList<ShopSearchActivityModel> tempGlobalShopsList = new ArrayList<ShopSearchActivityModel>();
        for (Shop shop_i : this.getAllShops()) {
            Location shopLoc = shop_i.getLocation();
            tempGlobalShopsList.add(new ShopSearchActivityModel(shopLoc.getWorld().getName(), shopLoc.getX(), shopLoc.getY(), shopLoc.getZ(), shopLoc.getPitch(), shopLoc.getYaw(), this.convertQUserToUUID(shop_i.getOwner()).toString(), new ArrayList<PlayerShopVisitModel>(), false));
        }
        for (ShopSearchActivityModel shop_temp : tempGlobalShopsList) {
            ShopSearchActivityModel tempShopToRemove = null;
            for (ShopSearchActivityModel shop_global : globalShopsList) {
                if (!shop_temp.getWorldName().equalsIgnoreCase(shop_global.getWorldName()) || shop_temp.getX() != shop_global.getX() || shop_temp.getY() != shop_global.getY() || shop_temp.getZ() != shop_global.getZ() || !shop_temp.getShopOwnerUUID().equalsIgnoreCase(shop_global.getShopOwnerUUID())) continue;
                shop_temp.setPlayerVisitList(shop_global.getPlayerVisitList());
                shop_temp.setHiddenFromSearch(shop_global.isHiddenFromSearch());
                tempShopToRemove = shop_global;
                break;
            }
            if (tempShopToRemove == null) continue;
            globalShopsList.remove(tempShopToRemove);
        }
        Logger.logDebugInfo("Shops List sync complete. Time took: " + (System.currentTimeMillis() - start) + "ms.");
        return tempGlobalShopsList;
    }

    @Override
    public void registerSubCommand() {
        Logger.logInfo("Unregistered find sub-command for /qs");
        for (CommandContainer cmdContainer : this.api.getCommandManager().getRegisteredCommands()) {
            if (!cmdContainer.getPrefix().equalsIgnoreCase("find")) continue;
            this.api.getCommandManager().unregisterCmd(cmdContainer);
            break;
        }
        Logger.logInfo("Registered finditem sub-command for /qs");
        this.api.getCommandManager().registerCmd(CommandContainer.builder().prefix("finditem").permission(PlayerPermsEnum.FINDITEM_USE.value()).hidden(false).description(locale -> Component.text((String)"Search for items from all shops using an interactive GUI")).executor((CommandHandler)new FindItemCmdHikariImpl()).build());
    }

    @Override
    public boolean isQSShopCacheImplemented() {
        return this.isQSHikariShopCacheImplemented;
    }

    @Override
    public int processUnknownStockSpace(Location shopLoc, boolean toBuy) {
        Util.ensureThread((boolean)false);
        Logger.logDebugInfo("Fetching stock/space from MAIN thread...");
        Shop qsShop = this.api.getShopManager().getShop(shopLoc);
        if (qsShop != null) {
            return toBuy ? qsShop.getRemainingStock() : qsShop.getRemainingSpace();
        }
        return -2;
    }

    private UUID convertQUserToUUID(QUser qUser) {
        Optional uuid = qUser.getUniqueIdOptional();
        if (uuid.isPresent()) {
            return (UUID)uuid.get();
        }
        String username = qUser.getUsernameOptional().orElse("Unknown");
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public UUID convertNameToUuid(String playerName) {
        return this.api.getPlayerFinder().name2Uuid(playerName);
    }

    private boolean isShopToBeIgnoredForFullOrEmpty(int stockOrSpace) {
        boolean ignoreEmptyChests = FindItemAddOn.getConfigProvider().IGNORE_EMPTY_CHESTS;
        if (ignoreEmptyChests) {
            return stockOrSpace == 0;
        }
        return false;
    }

    private int getRemainingStockOrSpaceFromShopCache___test(Shop shop, boolean fetchRemainingStock) {
        Logger.logDebugInfo("Shop ID: " + shop.getShopId());
        CachedShop cachedShop = (CachedShop)this.shopCache.get(shop.getShopId());
        if (cachedShop == null || QSApi.isTimeDifferenceGreaterThanSeconds(cachedShop.getLastFetched(), new Date(), 300)) {
            cachedShop = CachedShop.builder().shopId(shop.getShopId()).remainingStock(shop.getRemainingStock()).remainingSpace(shop.getRemainingSpace()).lastFetched(new Date()).build();
            this.shopCache.put(cachedShop.getShopId(), cachedShop);
            Logger.logDebugInfo("Adding to ShopCache: " + shop.getShopId());
        }
        return fetchRemainingStock ? cachedShop.getRemainingStock() : cachedShop.getRemainingSpace();
    }

    private int getRemainingStockOrSpaceFromShopCache(Shop shop, boolean fetchRemainingStock) {
        String mainVersionStr = this.pluginVersion.split("\\.")[0];
        int mainVersion = Integer.parseInt(mainVersionStr);
        if (mainVersion >= 6) {
            Util.ensureThread((boolean)true);
            int stockOrSpace = fetchRemainingStock ? shop.getRemainingStock() : shop.getRemainingSpace();
            Logger.logDebugInfo("Stock/Space from cache: " + stockOrSpace);
            return stockOrSpace;
        }
        Logger.logWarning("Update recommended to QuickShop-Hikari v6+! You are still using v" + this.pluginVersion);
        CachedShop cachedShop = (CachedShop)this.shopCache.get(shop.getShopId());
        if (cachedShop == null || QSApi.isTimeDifferenceGreaterThanSeconds(cachedShop.getLastFetched(), new Date(), 300)) {
            cachedShop = CachedShop.builder().shopId(shop.getShopId()).remainingStock(shop.getRemainingStock()).remainingSpace(shop.getRemainingSpace()).lastFetched(new Date()).build();
            this.shopCache.put(cachedShop.getShopId(), cachedShop);
            Logger.logDebugInfo("Adding to ShopCache: " + shop.getShopId());
        }
        return fetchRemainingStock ? cachedShop.getRemainingStock() : cachedShop.getRemainingSpace();
    }

    private void testQuickShopHikariExternalCache(Shop shop) throws RuntimeException {
        boolean fetchRemainingStock = false;
        long shopId = shop.getShopId();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)((TableQueryBuilder)((TableQueryBuilder)DataTables.EXTERNAL_CACHE.createQuery().addCondition("shop", (Object)shopId)).selectColumns(new String[]{"space", "stock"}).setLimit(1)).build()).execute();
             ResultSet resultSet = query.getResultSet();){
            if (resultSet.next()) {
                long stock = resultSet.getLong("stock");
                long space = resultSet.getLong("space");
                Logger.logWarning("1: Location: " + String.valueOf(shop.getLocation()) + " | Stock: " + stock + " | Space: " + space);
            } else {
                Logger.logWarning("No cached data found!");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkIfQSHikariShopCacheImplemented() {
        String mainVersionStr = this.pluginVersion.split("\\.")[0];
        int mainVersion = Integer.parseInt(mainVersionStr);
        return mainVersion >= 6;
    }

    private void processPotentialShopMatchAndAddToFoundList(boolean toBuy, Shop shopIterator, List<FoundShopItemModel> shopsFoundList, Player searchingPlayer) {
        int stockOrSpace;
        Logger.logDebugInfo("Shop match found: " + String.valueOf(shopIterator.getLocation()));
        if (FindItemAddOn.getConfigProvider().BENTOBOX_IGNORE_LOCKED_ISLAND_SHOPS && FindItemAddOn.getBentoboxPlugin().isIslandLocked(shopIterator.getLocation(), searchingPlayer)) {
            Logger.logDebugInfo("Shop is in locked BentoBox island - ignoring");
            return;
        }
        int n = stockOrSpace = toBuy ? this.getRemainingStockOrSpaceFromShopCache(shopIterator, true) : this.getRemainingStockOrSpaceFromShopCache(shopIterator, false);
        if (this.isShopToBeIgnoredForFullOrEmpty(stockOrSpace)) {
            return;
        }
        if (!toBuy && !QSHikariAPIHandler.isOwnerHavingEnoughBalance(shopIterator)) {
            Logger.logDebugInfo("Shop Owner is poor");
            return;
        }
        shopsFoundList.add(new FoundShopItemModel(shopIterator.getPrice(), QSApi.processStockOrSpace(stockOrSpace), shopIterator.getOwner().getUniqueIdOptional().orElse(new UUID(0L, 0L)), shopIterator.getLocation(), shopIterator.getItem(), toBuy));
    }
}

