/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.quickshop.impl;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.commands.quickshop.subcommands.FindItemCmdReremakeImpl;
import io.myzticbean.finditemaddon.models.CachedShop;
import io.myzticbean.finditemaddon.models.FoundShopItemModel;
import io.myzticbean.finditemaddon.models.PlayerShopVisitModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.quickshop.QSApi;
import io.myzticbean.finditemaddon.utils.json.HiddenShopStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.api.QuickShopAPI;
import org.maxgamer.quickshop.api.command.CommandContainer;
import org.maxgamer.quickshop.api.command.CommandHandler;
import org.maxgamer.quickshop.api.shop.Shop;
import org.maxgamer.quickshop.util.Util;

@Deprecated(since="2.0.6.0")
public class QSReremakeAPIHandler
implements QSApi<QuickShop, Shop> {
    private final QuickShopAPI api = (QuickShopAPI)Bukkit.getPluginManager().getPlugin("QuickShop");
    private final QuickShop quickShop = (QuickShop)Bukkit.getPluginManager().getPlugin("QuickShop");
    private final ConcurrentMap<Location, CachedShop> shopCache;
    private final int SHOP_CACHE_TIMEOUT_SECONDS = 60;
    private final String QS_REREMAKE_PLUGIN_NAME = "QuickShop";

    public QSReremakeAPIHandler() {
        Logger.logInfo("Initializing Shop caching");
        this.shopCache = new ConcurrentHashMap<Location, CachedShop>();
    }

    @Override
    public List<FoundShopItemModel> findItemBasedOnTypeFromAllShops(ItemStack item, boolean toBuy, Player searchingPlayer) {
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        ArrayList allShops = FindItemAddOn.getConfigProvider().SEARCH_LOADED_SHOPS_ONLY ? new ArrayList(this.api.getShopManager().getLoadedShops()) : this.api.getShopManager().getAllShops();
        QSReremakeAPIHandler.logTotalShopsOnServer(allShops.size());
        for (Shop shop_i : allShops) {
            if (FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shop_i.getLocation().getWorld()) || !shop_i.getItem().getType().equals((Object)item.getType()) || !(toBuy ? shop_i.isSelling() : shop_i.isBuying()) || this.checkIfShopToBeIgnoredForFullOrEmpty(toBuy, shop_i) || HiddenShopStorageUtil.isShopHidden(shop_i)) continue;
            shopsFoundList.add(new FoundShopItemModel(shop_i.getPrice(), QSApi.processStockOrSpace(toBuy ? this.getRemainingStockOrSpaceFromShopCache(shop_i, true) : this.getRemainingStockOrSpaceFromShopCache(shop_i, false)), shop_i.getOwner(), shop_i.getLocation(), shop_i.getItem(), toBuy));
        }
        List<FoundShopItemModel> sortedShops = QSReremakeAPIHandler.handleShopSorting(toBuy, shopsFoundList);
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    @Override
    public List<FoundShopItemModel> findItemBasedOnDisplayNameFromAllShops(String displayName, boolean toBuy, Player searchingPlayer) {
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        ArrayList allShops = FindItemAddOn.getConfigProvider().SEARCH_LOADED_SHOPS_ONLY ? new ArrayList(this.api.getShopManager().getLoadedShops()) : this.api.getShopManager().getAllShops();
        QSReremakeAPIHandler.logTotalShopsOnServer(allShops.size());
        for (Shop shop_i : allShops) {
            if (FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shop_i.getLocation().getWorld()) || !shop_i.getItem().hasItemMeta() || !Objects.requireNonNull(shop_i.getItem().getItemMeta()).hasDisplayName() || !shop_i.getItem().getItemMeta().getDisplayName().toLowerCase().contains(displayName.toLowerCase()) || !(toBuy ? shop_i.isSelling() : shop_i.isBuying()) || this.checkIfShopToBeIgnoredForFullOrEmpty(toBuy, shop_i) || HiddenShopStorageUtil.isShopHidden(shop_i)) continue;
            shopsFoundList.add(new FoundShopItemModel(shop_i.getPrice(), QSApi.processStockOrSpace(toBuy ? this.getRemainingStockOrSpaceFromShopCache(shop_i, true) : this.getRemainingStockOrSpaceFromShopCache(shop_i, false)), shop_i.getOwner(), shop_i.getLocation(), shop_i.getItem(), toBuy));
        }
        List<FoundShopItemModel> sortedShops = QSReremakeAPIHandler.handleShopSorting(toBuy, shopsFoundList);
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    @Override
    public List<FoundShopItemModel> fetchAllItemsFromAllShops(boolean toBuy, Player searchingPlayer) {
        Instant begin = Instant.now();
        ArrayList<FoundShopItemModel> shopsFoundList = new ArrayList<FoundShopItemModel>();
        ArrayList allShops = FindItemAddOn.getConfigProvider().SEARCH_LOADED_SHOPS_ONLY ? new ArrayList(this.api.getShopManager().getLoadedShops()) : this.api.getShopManager().getAllShops();
        QSReremakeAPIHandler.logTotalShopsOnServer(allShops.size());
        for (Shop shop_i : allShops) {
            if (FindItemAddOn.getConfigProvider().getBlacklistedWorlds().contains(shop_i.getLocation().getWorld()) || !(toBuy ? shop_i.isSelling() : shop_i.isBuying()) || this.checkIfShopToBeIgnoredForFullOrEmpty(toBuy, shop_i) || HiddenShopStorageUtil.isShopHidden(shop_i)) continue;
            shopsFoundList.add(new FoundShopItemModel(shop_i.getPrice(), QSApi.processStockOrSpace(toBuy ? this.getRemainingStockOrSpaceFromShopCache(shop_i, true) : this.getRemainingStockOrSpaceFromShopCache(shop_i, false)), shop_i.getOwner(), shop_i.getLocation(), shop_i.getItem(), toBuy));
        }
        List<FoundShopItemModel> sortedShops = new ArrayList<FoundShopItemModel>(shopsFoundList);
        if (!shopsFoundList.isEmpty()) {
            int sortingMethod = 1;
            sortedShops = QSApi.sortShops(sortingMethod, shopsFoundList, toBuy);
        }
        QSApi.logTimeTookMsg(begin);
        return sortedShops;
    }

    @Override
    public Material getShopSignMaterial() {
        return Util.getSignMaterial();
    }

    @Override
    public Shop findShopAtLocation(Block block) {
        Location loc = new Location(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
        return this.api.getShopManager().getShop(loc);
    }

    @Override
    public boolean isShopOwnerCommandRunner(Player player, Shop shop) {
        Logger.logDebugInfo("Shop owner: " + String.valueOf(shop.getOwner()) + " | Player: " + String.valueOf(player.getUniqueId()));
        return shop.getOwner().toString().equalsIgnoreCase(player.getUniqueId().toString());
    }

    @Override
    public List<Shop> getAllShops() {
        return this.api.getShopManager().getAllShops();
    }

    @Override
    public List<ShopSearchActivityModel> syncShopsListForStorage(List<ShopSearchActivityModel> globalShopsList) {
        ArrayList<ShopSearchActivityModel> tempGlobalShopsList = new ArrayList<ShopSearchActivityModel>();
        for (Shop shop_i : this.getAllShops()) {
            Location shopLoc = shop_i.getLocation();
            tempGlobalShopsList.add(new ShopSearchActivityModel(shopLoc.getWorld().getName(), shopLoc.getX(), shopLoc.getY(), shopLoc.getZ(), shopLoc.getPitch(), shopLoc.getYaw(), shop_i.getOwner().toString(), new ArrayList<PlayerShopVisitModel>(), false));
        }
        for (ShopSearchActivityModel shop_temp : tempGlobalShopsList) {
            ShopSearchActivityModel tempShopToRemove = null;
            for (ShopSearchActivityModel shop_global : globalShopsList) {
                if (!shop_temp.getWorldName().equalsIgnoreCase(shop_global.getWorldName()) || shop_temp.getX() != shop_global.getX() || shop_temp.getY() != shop_global.getY() || shop_temp.getZ() != shop_global.getZ() || !shop_temp.getShopOwnerUUID().equalsIgnoreCase(shop_global.getShopOwnerUUID())) continue;
                shop_temp.setPlayerVisitList(shop_global.getPlayerVisitList());
                shop_temp.setHiddenFromSearch(shop_global.isHiddenFromSearch());
                tempShopToRemove = shop_global;
                break;
            }
            if (tempShopToRemove == null) continue;
            globalShopsList.remove(tempShopToRemove);
        }
        return tempGlobalShopsList;
    }

    @Override
    public void registerSubCommand() {
        Logger.logInfo("Unregistered find sub-command for /qs");
        for (CommandContainer cmdContainer : this.api.getCommandManager().getRegisteredCommands()) {
            if (!cmdContainer.getPrefix().equalsIgnoreCase("find")) continue;
            this.api.getCommandManager().unregisterCmd(cmdContainer);
            break;
        }
        Logger.logInfo("Registered finditem sub-command for /qs");
        this.api.getCommandManager().registerCmd(CommandContainer.builder().prefix("finditem").permission(PlayerPermsEnum.FINDITEM_USE.value()).hidden(false).description("Search for items from all shops using an interactive GUI").executor((CommandHandler)new FindItemCmdReremakeImpl()).build());
    }

    @Override
    public UUID convertNameToUuid(String playerName) {
        return null;
    }

    @NotNull
    static List<FoundShopItemModel> handleShopSorting(boolean toBuy, List<FoundShopItemModel> shopsFoundList) {
        if (!shopsFoundList.isEmpty()) {
            int sortingMethod = 2;
            try {
                sortingMethod = FindItemAddOn.getConfigProvider().SHOP_SORTING_METHOD;
            }
            catch (Exception e) {
                Logger.logError("Invalid value in config.yml : 'shop-sorting-method'");
                Logger.logError("Defaulting to sorting by prices method");
            }
            return QSApi.sortShops(sortingMethod, shopsFoundList, toBuy);
        }
        return shopsFoundList;
    }

    private boolean checkIfShopToBeIgnoredForFullOrEmpty(boolean toBuy, Shop shop) {
        boolean ignoreEmptyChests = FindItemAddOn.getConfigProvider().IGNORE_EMPTY_CHESTS;
        if (ignoreEmptyChests) {
            if (toBuy) {
                return this.getRemainingStockOrSpaceFromShopCache(shop, true) == 0;
            }
            return this.getRemainingStockOrSpaceFromShopCache(shop, false) == 0;
        }
        return false;
    }

    private int getRemainingStockOrSpaceFromShopCache(Shop shop, boolean fetchRemainingStock) {
        Logger.logDebugInfo("Shop Location: " + String.valueOf(shop.getLocation()));
        CachedShop cachedShop = (CachedShop)this.shopCache.get(shop.getLocation());
        if (cachedShop == null || QSApi.isTimeDifferenceGreaterThanSeconds(cachedShop.getLastFetched(), new Date(), 60)) {
            Shop possibleCachedShop = this.getRemainingStockOrSpaceFromQSCache(shop);
            if (possibleCachedShop != null) {
                Logger.logDebugInfo("Shop found from QS cache: " + String.valueOf(shop.getLocation()));
                cachedShop = CachedShop.builder().shopLocation(possibleCachedShop.getLocation()).remainingStock(possibleCachedShop.getRemainingStock()).remainingSpace(possibleCachedShop.getRemainingSpace()).lastFetched(new Date()).build();
                this.shopCache.put(cachedShop.getShopLocation(), cachedShop);
                Logger.logDebugInfo("Added to ShopCache: " + String.valueOf(shop.getLocation()));
            } else {
                Logger.logDebugInfo("No shop found from QS cache for location: " + String.valueOf(shop.getLocation()));
            }
        } else {
            Logger.logDebugInfo("Shop found from cache: " + String.valueOf(shop.getLocation()));
        }
        return fetchRemainingStock ? (cachedShop != null ? cachedShop.getRemainingStock() : -1) : (cachedShop != null ? cachedShop.getRemainingSpace() : -1);
    }

    @Nullable
    private Shop getRemainingStockOrSpaceFromQSCache(Shop shop) {
        return this.quickShop.getShopCache().find(shop.getLocation(), false);
    }

    private static void logTotalShopsOnServer(int allShopsCount) {
        Logger.logDebugInfo("Total shops on server: " + allShopsCount);
    }

    @Override
    public boolean isQSShopCacheImplemented() {
        return false;
    }

    @Override
    public int processUnknownStockSpace(Location shopLoc, boolean toBuy) {
        return -2;
    }
}

