/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.models.HiddenShopModel;
import io.myzticbean.finditemaddon.models.PlayerShopVisitModel;
import io.myzticbean.finditemaddon.models.ShopSearchActivityModel;
import io.myzticbean.finditemaddon.utils.async.VirtualThreadScheduler;
import io.myzticbean.finditemaddon.utils.json.HiddenShopStorageUtil;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.api.shop.Shop;

public class ShopSearchActivityStorageUtil {
    private static final String SHOP_SEARCH_ACTIVITY_JSON_FILE_NAME = "shops.json";
    private static final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private static List<ShopSearchActivityModel> globalShopsList = new ArrayList<ShopSearchActivityModel>();

    private static boolean handleCooldownIfPresent(Location shopLocation, Player player) {
        for (ShopSearchActivityModel shopSearchActivity : globalShopsList) {
            if (!shopSearchActivity.compareWith(shopLocation.getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            List playerShopVisitList = shopSearchActivity.getPlayerVisitList().stream().filter(p -> p.getPlayerUUID().equals(player.getUniqueId())).sorted(Comparator.comparing(PlayerShopVisitModel::getVisitDateTime)).collect(Collectors.toCollection(ArrayList::new));
            boolean isCooldownTimeElapsed = playerShopVisitList.size() > 0 ? Instant.now().minusSeconds(FindItemAddOn.getConfigProvider().SHOP_PLAYER_VISIT_COOLDOWN_IN_MINUTES * 60).isAfter(((PlayerShopVisitModel)playerShopVisitList.get(playerShopVisitList.size() - 1)).getVisitDateTime()) : true;
            if (isCooldownTimeElapsed) {
                Logger.logDebugInfo(ColorTranslator.translateColorCodes("&6" + player.getName() + " is out of cooldown"));
                return true;
            }
            Logger.logDebugInfo(ColorTranslator.translateColorCodes("&6" + player.getName() + " still has cooldown"));
            return false;
        }
        Logger.logDebugInfo(ColorTranslator.translateColorCodes("&6Shop not found, returning false for cooldown check"));
        return false;
    }

    public static void syncShops() {
        globalShopsList = FindItemAddOn.getQsApiInstance().syncShopsListForStorage(globalShopsList);
    }

    public void addShop(Shop shop) {
        for (ShopSearchActivityModel shop_i : globalShopsList) {
            if (shop_i.getX() == shop.getLocation().getX() && shop_i.getY() == shop.getLocation().getY() && shop_i.getZ() == shop.getLocation().getZ() && shop_i.getWorldName().equalsIgnoreCase(shop.getLocation().getWorld().getName())) break;
        }
        ShopSearchActivityModel shopModel = new ShopSearchActivityModel(shop.getLocation().getWorld().getName(), shop.getLocation().getX(), shop.getLocation().getY(), shop.getLocation().getZ(), shop.getLocation().getPitch(), shop.getLocation().getYaw(), shop.getOwner().toString(), new ArrayList<PlayerShopVisitModel>(), false);
        globalShopsList.add(shopModel);
    }

    public static void addShop(com.ghostchu.quickshop.api.shop.Shop shop) {
        ShopSearchActivityModel shopModel = new ShopSearchActivityModel(shop.getLocation().getWorld().getName(), shop.getLocation().getX(), shop.getLocation().getY(), shop.getLocation().getZ(), shop.getLocation().getPitch(), shop.getLocation().getYaw(), shop.getOwner().toString(), new ArrayList<PlayerShopVisitModel>(), false);
        globalShopsList.add(shopModel);
    }

    public static void removeShop(com.ghostchu.quickshop.api.shop.Shop shop) {
        Iterator<ShopSearchActivityModel> shopSearchActivityIterator = globalShopsList.iterator();
        while (shopSearchActivityIterator.hasNext()) {
            ShopSearchActivityModel shopSearchActivity = shopSearchActivityIterator.next();
            if (!shopSearchActivity.compareWith(shop.getLocation().getWorld().getName(), shop.getLocation().getX(), shop.getLocation().getY(), shop.getLocation().getZ())) continue;
            shopSearchActivityIterator.remove();
            return;
        }
    }

    public static void loadShopsFromFile() {
        Gson gson = new GsonBuilder().create();
        File file = new File(FindItemAddOn.getInstance().getDataFolder().getAbsolutePath() + "/shops.json");
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                ShopSearchActivityModel[] h = gson.fromJson((Reader)reader, ShopSearchActivityModel[].class);
                globalShopsList = h != null ? new ArrayList<ShopSearchActivityModel>(Arrays.asList(h)) : new ArrayList<ShopSearchActivityModel>();
                Logger.logInfo("Loaded shops from file");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        globalShopsList = FindItemAddOn.getQsApiInstance().syncShopsListForStorage(globalShopsList);
    }

    public static void saveShopsToFile() {
        Gson gson = new GsonBuilder().create();
        File file = new File(FindItemAddOn.getInstance().getDataFolder().getAbsolutePath() + "/shops.json");
        file.getParentFile().mkdir();
        try {
            file.createNewFile();
            FileWriter writer = new FileWriter(file, false);
            gson.toJson(globalShopsList, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            Logger.logInfo("Saved shops to file");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void migrateHiddenShopsToShopsJson() {
        File hiddenShopsJsonfile = new File(FindItemAddOn.getInstance().getDataFolder().getAbsolutePath() + "/hiddenShops.json");
        if (hiddenShopsJsonfile.exists()) {
            HiddenShopStorageUtil.loadHiddenShopsFromFile();
            if (HiddenShopStorageUtil.hiddenShopsList.size() > 0) {
                for (int globalShopsList_i = 0; globalShopsList_i < globalShopsList.size(); ++globalShopsList_i) {
                    ShopSearchActivityModel shopSearchActivity = globalShopsList.get(globalShopsList_i);
                    HiddenShopModel tempHiddenShop = null;
                    for (HiddenShopModel hiddenShop_i : HiddenShopStorageUtil.hiddenShopsList) {
                        if (!shopSearchActivity.compareWith(hiddenShop_i.getWorldName(), hiddenShop_i.getX(), hiddenShop_i.getY(), hiddenShop_i.getZ(), hiddenShop_i.getShopOwnerUUID())) continue;
                        tempHiddenShop = hiddenShop_i;
                        shopSearchActivity.setHiddenFromSearch(true);
                        globalShopsList.set(globalShopsList_i, shopSearchActivity);
                        Logger.logDebugInfo("Converted shop: " + String.valueOf(shopSearchActivity));
                    }
                    HiddenShopStorageUtil.hiddenShopsList.remove(tempHiddenShop);
                }
            }
            Logger.logDebugInfo("Here we will delete the hiddenShops.json");
            hiddenShopsJsonfile.delete();
        } else {
            Logger.logDebugInfo("hiddenshops.json: No conversion required");
        }
    }

    public static void addPlayerVisitEntryAsync(Location shopLocation, Player visitingPlayer) {
        VirtualThreadScheduler.runTaskAsync(() -> {
            if (ShopSearchActivityStorageUtil.handleCooldownIfPresent(shopLocation, visitingPlayer)) {
                Iterator<ShopSearchActivityModel> shopSearchActivityIterator = globalShopsList.iterator();
                int i = 0;
                while (shopSearchActivityIterator.hasNext()) {
                    ShopSearchActivityModel shopSearchActivity = shopSearchActivityIterator.next();
                    if (shopSearchActivity.compareWith(shopLocation.getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) {
                        PlayerShopVisitModel playerShopVisit = new PlayerShopVisitModel();
                        playerShopVisit.setPlayerUUID(visitingPlayer.getUniqueId());
                        playerShopVisit.setVisitDateTime();
                        globalShopsList.get(i).getPlayerVisitList().add(playerShopVisit);
                        Logger.logDebugInfo("Added new player visit entry at " + String.valueOf(shopLocation));
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    public static int getPlayerVisitCount(Location shopLocation) {
        for (ShopSearchActivityModel shopSearchActivity : globalShopsList) {
            if (!shopSearchActivity.compareWith(shopLocation.getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            return shopSearchActivity.getPlayerVisitList().size();
        }
        return 0;
    }

    @Nullable
    public static OfflinePlayer getShopOwner(@NotNull Location shopLocation) {
        for (ShopSearchActivityModel shopSearchActivity : globalShopsList) {
            if (!shopSearchActivity.compareWith(shopLocation.getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(shopSearchActivity.getShopOwnerUUID()));
        }
        return null;
    }

    @Nullable
    public static UUID getShopOwnerUUID(@NotNull Location shopLocation) {
        for (ShopSearchActivityModel shopSearchActivity : globalShopsList) {
            if (!shopSearchActivity.compareWith(shopLocation.getWorld().getName(), shopLocation.getX(), shopLocation.getY(), shopLocation.getZ())) continue;
            String uuidStr = shopSearchActivity.getShopOwnerUUID();
            try {
                return UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException e) {
                if (!FindItemAddOn.isQSReremakeInstalled()) {
                    UUID uuid = FindItemAddOn.getQsApiInstance().convertNameToUuid(uuidStr);
                    int index = globalShopsList.indexOf(shopSearchActivity);
                    globalShopsList.get(index).setShopOwnerUUID(uuid.toString());
                }
                return UUID.fromString(shopSearchActivity.getShopOwnerUUID());
            }
        }
        return null;
    }

    @Generated
    public static Map<String, Long> getCooldowns() {
        return cooldowns;
    }

    @Generated
    public static List<ShopSearchActivityModel> getGlobalShopsList() {
        return globalShopsList;
    }
}

