/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.warp;

import io.myzticbean.finditemaddon.dependencies.EssentialsXPlugin;
import io.myzticbean.finditemaddon.models.EssentialWarpModel;
import io.myzticbean.finditemaddon.utils.CommonUtils;
import java.util.List;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class EssentialWarpsUtil {
    @Nullable
    public static String findNearestWarp(Location shopLocation) {
        List<EssentialWarpModel> allWarps = EssentialsXPlugin.getAllWarps();
        if (allWarps != null && !allWarps.isEmpty()) {
            TreeMap warpDistanceMap = new TreeMap();
            allWarps.forEach(warp -> {
                Double distance = CommonUtils.calculateDistance3D(shopLocation.getX(), shopLocation.getY(), shopLocation.getZ(), warp.warpLoc.getX(), warp.warpLoc.getY(), warp.warpLoc.getZ());
                warpDistanceMap.put(distance, warp.warpName);
            });
            return (String)warpDistanceMap.entrySet().iterator().next().getValue();
        }
        return null;
    }

    public static void warpPlayer(Player player, String warpName) {
        Bukkit.dispatchCommand((CommandSender)player, (String)("essentials:warp " + warpName));
    }

    @Generated
    private EssentialWarpsUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

