/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils;

import io.myzticbean.finditemaddon.FindItemAddOn;
import io.myzticbean.finditemaddon.models.enums.PlayerPermsEnum;
import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class LocationUtils {
    private static final List<Material> damagingBlocks = new ArrayList<Material>();
    private static final List<Material> nonSuffocatingBlocks = new ArrayList<Material>();
    private static final int BELOW_SAFE_BLOCK_CHECK_LIMIT = 20;

    @Nullable
    public static Location findSafeLocationAroundShop(Location shopLocation, Player player) {
        Location roundedShopLoc = LocationUtils.getRoundedDestination(shopLocation);
        Logger.logDebugInfo("Rounded location: " + roundedShopLoc.getX() + ", " + roundedShopLoc.getY() + ", " + roundedShopLoc.getZ());
        ArrayList<Location> possibleSafeLocList = new ArrayList<Location>();
        possibleSafeLocList.add(new Location(roundedShopLoc.getWorld(), roundedShopLoc.getX() + 1.0, roundedShopLoc.getY(), roundedShopLoc.getZ()));
        possibleSafeLocList.add(new Location(roundedShopLoc.getWorld(), roundedShopLoc.getX() - 1.0, roundedShopLoc.getY(), roundedShopLoc.getZ()));
        possibleSafeLocList.add(new Location(roundedShopLoc.getWorld(), roundedShopLoc.getX(), roundedShopLoc.getY(), roundedShopLoc.getZ() + 1.0));
        possibleSafeLocList.add(new Location(roundedShopLoc.getWorld(), roundedShopLoc.getX(), roundedShopLoc.getY(), roundedShopLoc.getZ() - 1.0));
        for (Location loc_i : possibleSafeLocList) {
            Logger.logDebugInfo("Possible safe location: " + loc_i.getX() + ", " + loc_i.getY() + ", " + loc_i.getZ());
            if (loc_i.getBlock().getType().equals((Object)FindItemAddOn.getQsApiInstance().getShopSignMaterial())) {
                Logger.logDebugInfo("Shop sign block found at " + loc_i.getX() + ", " + loc_i.getY() + ", " + loc_i.getZ());
                if (player.hasPermission(PlayerPermsEnum.FINDITEM_SHOPTP_BYPASS_SAFETYCHECK.value())) {
                    Location blockBelow = new Location(loc_i.getWorld(), (double)loc_i.getBlockX(), (double)(loc_i.getBlockY() - 1), (double)loc_i.getBlockZ());
                    loc_i = LocationUtils.lookAt(LocationUtils.getRoundedDestination(new Location(blockBelow.getWorld(), blockBelow.getX(), blockBelow.getY() + 1.0, blockBelow.getZ())), roundedShopLoc);
                    return loc_i;
                }
                Location blockAbove = new Location(loc_i.getWorld(), (double)loc_i.getBlockX(), (double)(loc_i.getBlockY() + 1), (double)loc_i.getBlockZ());
                Logger.logDebugInfo("Block above shop sign: " + blockAbove.getX() + ", " + blockAbove.getY() + ", " + blockAbove.getZ());
                if (!LocationUtils.isBlockSuffocating(blockAbove)) {
                    Location blockBelow = null;
                    boolean safeLocFound = false;
                    for (int i = 1; i <= 20; ++i) {
                        blockBelow = new Location(loc_i.getWorld(), (double)loc_i.getBlockX(), (double)(loc_i.getBlockY() - i), (double)loc_i.getBlockZ());
                        Logger.logDebugInfo("Block below shop sign: " + String.valueOf(blockBelow.getBlock().getType()) + " " + blockBelow.getX() + ", " + blockBelow.getY() + ", " + blockBelow.getZ());
                        if (!(blockBelow.getBlock().getType().equals((Object)Material.AIR) || blockBelow.getBlock().getType().equals((Object)Material.CAVE_AIR) || blockBelow.getBlock().getType().equals((Object)Material.VOID_AIR) || blockBelow.getBlock().getType().equals((Object)FindItemAddOn.getQsApiInstance().getShopSignMaterial()))) {
                            if (LocationUtils.isBlockDamaging(blockBelow)) break;
                            Logger.logDebugInfo("Safe block found!");
                            safeLocFound = true;
                            break;
                        }
                        Logger.logDebugInfo("Shop or Air found below");
                    }
                    if (safeLocFound) {
                        loc_i = LocationUtils.lookAt(LocationUtils.getRoundedDestination(new Location(blockBelow.getWorld(), blockBelow.getX(), blockBelow.getY() + 1.0, blockBelow.getZ())), roundedShopLoc);
                        return loc_i;
                    }
                    return null;
                }
                Logger.logDebugInfo("Block above shop sign found not air. Block type: " + String.valueOf(blockAbove.getBlock().getType()));
                return null;
            }
            Logger.logDebugInfo("Block not shop sign. Block type: " + String.valueOf(loc_i.getBlock().getType()));
        }
        Logger.logDebugInfo("No safe block found near shop");
        return null;
    }

    private static Location lookAt(Location loc, Location lookat) {
        loc = loc.clone();
        double dx = lookat.getX() - loc.getX();
        double dy = lookat.getY() - loc.getY();
        double dz = lookat.getZ() - loc.getZ();
        if (dx != 0.0) {
            if (dx < 0.0) {
                loc.setYaw(4.712389f);
            } else {
                loc.setYaw(1.5707964f);
            }
            loc.setYaw(loc.getYaw() - (float)Math.atan(dz / dx));
        } else if (dz < 0.0) {
            loc.setYaw((float)Math.PI);
        }
        double dxz = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        loc.setPitch((float)(-Math.atan(dy / dxz)));
        loc.setYaw(-loc.getYaw() * 180.0f / (float)Math.PI);
        loc.setPitch(loc.getPitch() * 180.0f / (float)Math.PI);
        return loc;
    }

    private static boolean isBlockDamaging(Location loc) {
        return damagingBlocks.contains(loc.getBlock().getType());
    }

    private static boolean isBlockSuffocating(Location loc) {
        return !nonSuffocatingBlocks.contains(loc.getBlock().getType());
    }

    private static Location getRoundedDestination(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = (int)Math.round(loc.getY());
        int z = loc.getBlockZ();
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, loc.getYaw(), loc.getPitch());
    }

    @Generated
    private LocationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        damagingBlocks.add(Material.LAVA);
        damagingBlocks.add(Material.CACTUS);
        damagingBlocks.add(Material.CAMPFIRE);
        damagingBlocks.add(Material.SOUL_CAMPFIRE);
        damagingBlocks.add(Material.MAGMA_BLOCK);
        damagingBlocks.add(Material.FIRE);
        damagingBlocks.add(Material.SOUL_FIRE);
        damagingBlocks.add(Material.SWEET_BERRY_BUSH);
        damagingBlocks.add(Material.WITHER_ROSE);
        damagingBlocks.add(Material.END_PORTAL);
        nonSuffocatingBlocks.add(Material.AIR);
        nonSuffocatingBlocks.add(Material.GLASS);
        nonSuffocatingBlocks.addAll(new ArrayList<Material>(Arrays.stream(Material.values()).filter(p -> p.toString().toLowerCase().contains("_glass")).toList()));
        nonSuffocatingBlocks.addAll(new ArrayList<Material>(Arrays.stream(Material.values()).filter(p -> p.toString().toLowerCase().contains("glass_pane")).toList()));
        nonSuffocatingBlocks.add(Material.ACACIA_LEAVES);
        nonSuffocatingBlocks.add(Material.BIRCH_LEAVES);
        nonSuffocatingBlocks.add(Material.DARK_OAK_LEAVES);
        nonSuffocatingBlocks.add(Material.JUNGLE_LEAVES);
        nonSuffocatingBlocks.add(Material.OAK_LEAVES);
        nonSuffocatingBlocks.add(Material.SPRUCE_LEAVES);
        if (Bukkit.getServer().getVersion().contains("1.17")) {
            nonSuffocatingBlocks.add(Material.AZALEA_LEAVES);
            nonSuffocatingBlocks.add(Material.FLOWERING_AZALEA_LEAVES);
        }
        nonSuffocatingBlocks.addAll(new ArrayList<Material>(Arrays.stream(Material.values()).filter(p -> p.toString().toLowerCase().contains("_slab")).toList()));
        nonSuffocatingBlocks.addAll(new ArrayList<Material>(Arrays.stream(Material.values()).filter(p -> p.toString().toLowerCase().contains("_sign")).toList()));
        nonSuffocatingBlocks.addAll(new ArrayList<Material>(Arrays.stream(Material.values()).filter(p -> p.toString().toLowerCase().contains("_stairs")).toList()));
        nonSuffocatingBlocks.add(Material.HONEY_BLOCK);
        nonSuffocatingBlocks.add(Material.BELL);
        nonSuffocatingBlocks.add(Material.CHEST);
        nonSuffocatingBlocks.add(Material.TRAPPED_CHEST);
        nonSuffocatingBlocks.add(Material.HOPPER);
        nonSuffocatingBlocks.add(Material.COMPOSTER);
        nonSuffocatingBlocks.add(Material.GRINDSTONE);
        nonSuffocatingBlocks.add(Material.STONECUTTER);
        nonSuffocatingBlocks.add(Material.IRON_BARS);
        nonSuffocatingBlocks.add(Material.END_PORTAL_FRAME);
        nonSuffocatingBlocks.add(Material.PISTON_HEAD);
    }
}

