/*
 * Decompiled with CFR 0.152.
 */
package io.myzticbean.finditemaddon.utils.async;

import io.myzticbean.finditemaddon.utils.log.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class VirtualThreadScheduler {
    private static final ExecutorService VIRTUAL_EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();

    private VirtualThreadScheduler() {
    }

    public static Future<?> runTaskAsync(Runnable task) {
        return VIRTUAL_EXECUTOR.submit(task);
    }

    public static <T> Future<T> runTaskAsync(Callable<T> task) {
        return VIRTUAL_EXECUTOR.submit(task);
    }

    public static void shutdown() {
        Logger.logInfo("Shutting down virtual thread executor...");
        VIRTUAL_EXECUTOR.shutdown();
    }
}

