/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.conversations;

import java.util.Objects;
import me.kodysimpson.simpapi.colors.ColorTranslator;
import me.kodysimpson.simpapi.conversations.ArrayMatchCanceller;
import me.kodysimpson.simpapi.conversations.ServerReloadListener;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.InactivityConversationCanceller;
import org.bukkit.entity.Player;

final class PrefixedAbandonedListener
implements ConversationAbandonedListener {
    private final String prefix;

    PrefixedAbandonedListener(String prefix) {
        this.prefix = prefix;
    }

    private static String tl(String msg) {
        return ColorTranslator.translateColorCodes(msg);
    }

    public void conversationAbandoned(ConversationAbandonedEvent abandonedEvent) {
        if (abandonedEvent.gracefulExit()) {
            return;
        }
        Player player = (Player)abandonedEvent.getContext().getForWhom();
        ConversationCanceller canceller = Objects.requireNonNull(abandonedEvent.getCanceller(), "[m.k.s.c.ArrayMatchCanceller] Canceller is null but gracefulExit is false");
        if (canceller instanceof ArrayMatchCanceller) {
            player.sendMessage(PrefixedAbandonedListener.tl(this.prefix + "&9Good bye!"));
            return;
        }
        if (canceller instanceof ServerReloadListener.ServerReloadCanceller) {
            player.sendMessage(PrefixedAbandonedListener.tl(this.prefix + "&9Server reloaded, quitting."));
            return;
        }
        if (canceller instanceof InactivityConversationCanceller) {
            player.sendMessage(PrefixedAbandonedListener.tl(this.prefix + "&9Session timed out."));
            return;
        }
        player.sendMessage(PrefixedAbandonedListener.tl(this.prefix + "&9Conversation cancelled by &#FF00FFcosmic energy&9."));
    }
}

