/*
 * Decompiled with CFR 0.152.
 */
package me.kodysimpson.simpapi.menu;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import me.kodysimpson.simpapi.exceptions.MenuManagerException;
import me.kodysimpson.simpapi.exceptions.MenuManagerNotSetupException;
import me.kodysimpson.simpapi.menu.Menu;
import me.kodysimpson.simpapi.menu.MenuListener;
import me.kodysimpson.simpapi.menu.PlayerMenuUtility;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class MenuManager {
    private static final HashMap<Player, PlayerMenuUtility> playerMenuUtilityMap = new HashMap();
    private static boolean isSetup = false;

    private static void registerMenuListener(Server server, Plugin plugin) {
        boolean isAlreadyRegistered = false;
        for (RegisteredListener rl : InventoryClickEvent.getHandlerList().getRegisteredListeners()) {
            if (!(rl.getListener() instanceof MenuListener)) continue;
            isAlreadyRegistered = true;
            break;
        }
        if (!isAlreadyRegistered) {
            server.getPluginManager().registerEvents((Listener)new MenuListener(), plugin);
        }
    }

    public static void setup(Server server, Plugin plugin) {
        plugin.getLogger().info("Menu Manager has been setup");
        MenuManager.registerMenuListener(server, plugin);
        isSetup = true;
    }

    public static void openMenu(Class<? extends Menu> menuClass, Player player) throws MenuManagerException, MenuManagerNotSetupException {
        try {
            menuClass.getConstructor(PlayerMenuUtility.class).newInstance(MenuManager.getPlayerMenuUtility(player)).open();
        }
        catch (InstantiationException e) {
            throw new MenuManagerException("Failed to instantiate menu class", e);
        }
        catch (IllegalAccessException e) {
            throw new MenuManagerException("Illegal access while trying to instantiate menu class", e);
        }
        catch (InvocationTargetException e) {
            throw new MenuManagerException("An error occurred while trying to invoke the menu class constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new MenuManagerException("The menu class constructor could not be found", e);
        }
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player p) throws MenuManagerNotSetupException {
        if (!isSetup) {
            throw new MenuManagerNotSetupException();
        }
        if (!playerMenuUtilityMap.containsKey(p)) {
            PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(p);
            playerMenuUtilityMap.put(p, playerMenuUtility);
            return playerMenuUtility;
        }
        return playerMenuUtilityMap.get(p);
    }
}

