/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy;

import io.github.townyadvanced.iconomy.commands.MoneyCommand;
import io.github.townyadvanced.iconomy.listener.PlayerJoinListener;
import io.github.townyadvanced.iconomy.providers.VaultEconomy;
import io.github.townyadvanced.iconomy.providers.VaultUnlockedEconomy;
import io.github.townyadvanced.iconomy.settings.LangStrings;
import io.github.townyadvanced.iconomy.settings.Settings;
import io.github.townyadvanced.iconomy.system.Accounts;
import io.github.townyadvanced.iconomy.system.BackEnd;
import io.github.townyadvanced.iconomy.system.Transactions;
import java.util.List;
import java.util.function.Function;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class iConomyUnlocked
extends JavaPlugin {
    private static iConomyUnlocked plugin;
    private static BackEnd backend;
    private static Accounts accounts;
    private static Transactions transactions;
    private static Function<Plugin, Boolean> vaultVersionFun;

    public iConomyUnlocked() {
        plugin = this;
    }

    public void onLoad() {
        if (!this.registerEconomy()) {
            this.getLogger().severe("Neither Vault or VaultUnlocked were found. Please download Vault or VaultUnlocked to use iConomyUnlocked!");
            this.disableWithMessage("Could not register with VaultUnlocked!");
            return;
        }
    }

    public void onEnable() {
        try {
            if (!this.testPaper()) {
                this.disableWithMessage("iConomyUnlocked no longer supports Spigot/CraftBukkit, and now requires Paper to run. See https://papermc.io for more information about Paper.");
                return;
            }
            this.loadConfig();
            this.loadLangFile();
            backend = new BackEnd();
            backend.setupAccountTable();
            List<String> tablesUpdated = backend.updateTables();
            accounts = new Accounts();
            if (!tablesUpdated.isEmpty()) {
                accounts.updateAccountsForNewTables(tablesUpdated);
            }
            transactions = new Transactions();
            backend.setupTransactionTable();
            this.registerCommands();
            this.registerListeners();
        }
        catch (Exception e) {
            this.disableWithMessage(e.getMessage());
            return;
        }
    }

    private boolean testPaper() {
        return this.classExists("io.papermc.paper.threadedregions.RegionizedServer") || this.classExists("io.papermc.paper.configuration.Configuration");
    }

    public void loadConfig() throws Exception {
        Settings.loadConfig(this.getDataFolder().toPath().resolve("config.yml"), this.getVersion());
    }

    public void loadLangFile() throws Exception {
        LangStrings.loadLangFile(this.getDataFolder().toPath().resolve("lang.yml"));
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    private boolean registerEconomy() {
        ServicesManager sm = this.getServer().getServicesManager();
        boolean vault2hooked = false;
        boolean vault1hooked = false;
        if (iConomyUnlocked.vaultUnlockedPresent()) {
            Class<net.milkbowl.vault2.economy.Economy> vaultUnlocked = net.milkbowl.vault2.economy.Economy.class;
            sm.register(vaultUnlocked, (Object)new VaultUnlockedEconomy(this), (Plugin)this, ServicePriority.Highest);
            this.getLogger().info("Registered VaultUnlocked interface.");
            vault2hooked = this.getServer().getServicesManager().getRegistration(vaultUnlocked) != null;
            Class<Economy> vault = Economy.class;
            sm.register(vault, (Object)new VaultEconomy(this), (Plugin)this, ServicePriority.Highest);
            this.getLogger().info("Registered Vault interface.");
            boolean bl = vault1hooked = this.getServer().getServicesManager().getRegistration(vault) != null;
        }
        if (iConomyUnlocked.vaultPresent()) {
            Class<Economy> vault = Economy.class;
            sm.register(vault, (Object)new VaultEconomy(this), (Plugin)this, ServicePriority.Highest);
            this.getLogger().info("Registered Vault interface.");
            vault1hooked = this.getServer().getServicesManager().getRegistration(vault) != null;
        }
        return vault1hooked || vault2hooked;
    }

    private static boolean vaultUnlockedPresent() {
        Plugin vault = plugin.getServer().getPluginManager().getPlugin("Vault");
        return vault != null && vaultVersionFun.apply(vault) == false;
    }

    private static boolean vaultPresent() {
        Plugin vault = plugin.getServer().getPluginManager().getPlugin("Vault");
        return vault != null && vaultVersionFun.apply(vault) != false;
    }

    private void registerCommands() {
        MoneyCommand cmd = new MoneyCommand();
        PluginCommand command = this.getCommand("money");
        command.setExecutor((CommandExecutor)cmd);
        command.setTabCompleter((TabCompleter)cmd);
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)plugin);
    }

    private void disableWithMessage(String message) {
        this.getLogger().severe(message);
        this.getLogger().severe("Disabling iConomyUnlocked...");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    public void onDisable() {
        try {
            backend.connectionPool().dispose();
            this.getLogger().info("Plugin disabled.");
        }
        catch (Exception e) {
            this.getLogger().severe("Plugin disabled.");
        }
        finally {
            transactions = null;
            accounts = null;
            backend = null;
        }
    }

    public static iConomyUnlocked getPlugin() {
        return plugin;
    }

    public static BackEnd getBackEnd() {
        return backend;
    }

    public static Accounts getAccounts() {
        return accounts;
    }

    public static Transactions getTransactions() {
        return transactions;
    }

    private boolean classExists(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        backend = null;
        accounts = null;
        transactions = null;
        vaultVersionFun = vault -> vault.getDescription().getVersion().startsWith("1");
    }
}

