/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.providers;

import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import io.github.townyadvanced.iconomy.system.Holdings;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VaultEconomy
implements Economy {
    private final iConomyUnlocked plugin;

    public VaultEconomy(iConomyUnlocked plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.plugin != null && this.plugin.isEnabled();
    }

    @NotNull
    public String getName() {
        return "iConomyUnlocked";
    }

    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return false;
        }
        this.createPlayerAccount((OfflinePlayer)player);
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        if (this.hasAccount(player)) {
            return false;
        }
        iConomyUnlocked.getAccounts().create(player.getUniqueId(), player.getName(), Settings.isNonPlayerAccountName(player.getName()));
        return true;
    }

    public boolean createPlayerAccount(String playerName, String arg1) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String arg1) {
        return this.createPlayerAccount(player);
    }

    public String currencyNamePlural() {
        try {
            return Settings.getCurrencyNamePlural();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String currencyNameSingular() {
        try {
            return Settings.getCurrencyNameSingular();
        }
        catch (Exception e) {
            return "";
        }
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "No player found with that name.");
        }
        return this.depositPlayer((OfflinePlayer)player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        String errorMessage = null;
        Holdings holdings = iConomyUnlocked.getAccounts().get(player.getUniqueId()).getHoldings();
        double balance = holdings.balance() + amount;
        holdings.add(amount);
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
        iConomyUnlocked.getTransactions().insert("[Vault]", player.getName(), 0.0, balance, 0.0, amount, 0.0);
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    public EconomyResponse depositPlayer(String playerName, String world, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        return this.depositPlayer(player, amount);
    }

    public String format(double amount) {
        return Settings.format(amount);
    }

    public int fractionalDigits() {
        return Settings.getVaultFractionalDigits();
    }

    public double getBalance(String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return 0.0;
        }
        return iConomyUnlocked.getAccounts().get(playerName).getHoldings().balance();
    }

    public double getBalance(OfflinePlayer player) {
        return iConomyUnlocked.getAccounts().get(player.getUniqueId()).getHoldings().balance();
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(String playerName, String world, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean hasAccount(String playerName) {
        return iConomyUnlocked.getAccounts().exists(playerName);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return iConomyUnlocked.getAccounts().exists(player.getUniqueId());
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean hasBankSupport() {
        return false;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "No player found with that name.");
        }
        return this.withdrawPlayer((OfflinePlayer)player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        String errorMessage = null;
        Holdings holdings = iConomyUnlocked.getAccounts().get(player.getUniqueId()).getHoldings();
        if (holdings.hasEnough(amount)) {
            double previousBalance = holdings.balance();
            holdings.subtract(amount);
            double balance = previousBalance - amount;
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        amount = 0.0;
        double balance = this.getBalance(player);
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        errorMessage = "Insufficient funds";
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    public EconomyResponse withdrawPlayer(String playerName, String world, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse bankBalance(String arg0) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse bankDeposit(String arg0, double arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse bankHas(String arg0, double arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse bankWithdraw(String arg0, double arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single account banks!");
    }

    public EconomyResponse createBank(String arg0, OfflinePlayer arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single account banks!");
    }

    public EconomyResponse isBankMember(String arg0, String arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse isBankMember(String arg0, OfflinePlayer arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse isBankOwner(String arg0, String arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse isBankOwner(String arg0, OfflinePlayer arg1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    public EconomyResponse deleteBank(String arg0) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support bank accounts!");
    }
}

