/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.providers;

import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import io.github.townyadvanced.iconomy.system.Account;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultUnlockedEconomy
implements Economy {
    private final iConomyUnlocked plugin;

    public VaultUnlockedEconomy(iConomyUnlocked plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.plugin != null && this.plugin.isEnabled();
    }

    @NotNull
    public String getName() {
        return "iConomyUnlocked";
    }

    public boolean hasSharedAccountSupport() {
        return false;
    }

    public boolean hasMultiCurrencySupport() {
        return false;
    }

    @NotNull
    public int fractionalDigits(String pluginName) {
        return Settings.getVaultFractionalDigits();
    }

    @NotNull
    public String format(BigDecimal amount) {
        return Settings.format(amount);
    }

    @NotNull
    public String format(String pluginName, BigDecimal amount) {
        return this.format(amount);
    }

    @NotNull
    public String format(BigDecimal amount, String currency) {
        return this.format(amount);
    }

    @NotNull
    public String format(String pluginName, BigDecimal amount, String currency) {
        return this.format(amount);
    }

    public boolean hasCurrency(String currency) {
        return currency.equalsIgnoreCase(Settings.getCurrencyName());
    }

    @NotNull
    public String getDefaultCurrency(String pluginName) {
        return Settings.getCurrencyName();
    }

    @NotNull
    public String defaultCurrencyNamePlural(String pluginName) {
        return Settings.getCurrencyName();
    }

    @NotNull
    public String defaultCurrencyNameSingular(String pluginName) {
        return Settings.getCurrencyName();
    }

    public Collection<String> currencies() {
        return Collections.singleton(Settings.getCurrencyName());
    }

    public boolean createAccount(UUID accountID, String name) {
        return this.createAccount(accountID, name, !Settings.isNonPlayerAccountName(name));
    }

    public boolean createAccount(UUID accountID, String name, String worldName) {
        return this.createAccount(accountID, name);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, boolean player) {
        return iConomyUnlocked.getAccounts().create(accountID, name, !player);
    }

    public boolean createAccount(@NotNull UUID accountID, @NotNull String name, @NotNull String worldName, boolean player) {
        return this.createAccount(accountID, name, player);
    }

    public Map<UUID, String> getUUIDNameMap() {
        return iConomyUnlocked.getAccounts().getUUIDNameMap();
    }

    public Optional<String> getAccountName(UUID accountID) {
        if (iConomyUnlocked.getAccounts().exists(accountID)) {
            return Optional.of(Account.getAccount(accountID).getName());
        }
        return Optional.empty();
    }

    public boolean hasAccount(UUID accountID) {
        return iConomyUnlocked.getAccounts().exists(accountID);
    }

    public boolean hasAccount(UUID accountID, String worldName) {
        return this.hasAccount(accountID);
    }

    public boolean renameAccount(UUID accountID, String name) {
        return iConomyUnlocked.getAccounts().get(accountID).setName(name);
    }

    public boolean renameAccount(String plugin, UUID accountID, String name) {
        return this.renameAccount(accountID, name);
    }

    public boolean deleteAccount(String plugin, UUID accountID) {
        iConomyUnlocked.getAccounts().get(accountID).remove();
        return true;
    }

    public boolean accountSupportsCurrency(String plugin, UUID accountID, String currency) {
        return currency.equalsIgnoreCase(Settings.getCurrencyName());
    }

    public boolean accountSupportsCurrency(String plugin, UUID accountID, String currency, String world) {
        return currency.equalsIgnoreCase(Settings.getCurrencyName());
    }

    @NotNull
    public BigDecimal getBalance(String pluginName, UUID accountID) {
        @Nullable Account account = Account.getAccount(accountID);
        if (account == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(account.getHoldings().balance());
    }

    @NotNull
    public BigDecimal getBalance(String pluginName, UUID accountID, String world) {
        return this.getBalance(pluginName, accountID);
    }

    @NotNull
    public BigDecimal getBalance(String pluginName, UUID accountID, String world, String currency) {
        return this.getBalance(pluginName, accountID);
    }

    public boolean has(String pluginName, UUID accountID, BigDecimal amount) {
        return this.getBalance(pluginName, accountID).compareTo(amount) != -1;
    }

    public boolean has(String pluginName, UUID accountID, String worldName, BigDecimal amount) {
        return this.has(pluginName, accountID, amount);
    }

    public boolean has(String pluginName, UUID accountID, String worldName, String currency, BigDecimal amount) {
        return this.has(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(String pluginName, UUID accountID, BigDecimal amount) {
        Account account = Account.getAccount(accountID);
        if (account == null) {
            return new EconomyResponse(amount, BigDecimal.ZERO, EconomyResponse.ResponseType.FAILURE, "No account found.");
        }
        if (!account.getHoldings().hasEnough(amount.doubleValue())) {
            return new EconomyResponse(amount, this.getBalance(pluginName, accountID), EconomyResponse.ResponseType.FAILURE, "Not enough funds.");
        }
        account.getHoldings().subtract(amount.doubleValue());
        iConomyUnlocked.getTransactions().insert(account.getName(), "[Vault]", 0.0, account.getHoldings().balance(), 0.0, 0.0, amount.doubleValue());
        return new EconomyResponse(amount, this.getBalance(pluginName, accountID), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @NotNull
    public EconomyResponse withdraw(String pluginName, UUID accountID, String worldName, BigDecimal amount) {
        return this.withdraw(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse withdraw(String pluginName, UUID accountID, String worldName, String currency, BigDecimal amount) {
        return this.withdraw(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(String pluginName, UUID accountID, BigDecimal amount) {
        Account account = Account.getAccount(accountID);
        if (account == null) {
            return new EconomyResponse(amount, BigDecimal.ZERO, EconomyResponse.ResponseType.FAILURE, "No account found.");
        }
        account.getHoldings().add(amount.doubleValue());
        iConomyUnlocked.getTransactions().insert("[Vault]", account.getName(), 0.0, account.getHoldings().balance(), 0.0, amount.doubleValue(), 0.0);
        return new EconomyResponse(amount, this.getBalance(pluginName, accountID), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @NotNull
    public EconomyResponse deposit(String pluginName, UUID accountID, String worldName, BigDecimal amount) {
        return this.deposit(pluginName, accountID, amount);
    }

    @NotNull
    public EconomyResponse deposit(String pluginName, UUID accountID, String worldName, String currency, BigDecimal amount) {
        return this.deposit(pluginName, accountID, amount);
    }

    public boolean createSharedAccount(String pluginName, UUID accountID, String name, UUID owner) {
        return false;
    }

    public boolean isAccountOwner(String pluginName, UUID accountID, UUID uuid) {
        return false;
    }

    public boolean setOwner(String pluginName, UUID accountID, UUID uuid) {
        return false;
    }

    public boolean isAccountMember(String pluginName, UUID accountID, UUID uuid) {
        return false;
    }

    public boolean addAccountMember(String pluginName, UUID accountID, UUID uuid) {
        return false;
    }

    public boolean addAccountMember(String pluginName, UUID accountID, UUID uuid, AccountPermission ... initialPermissions) {
        return false;
    }

    public boolean removeAccountMember(String pluginName, UUID accountID, UUID uuid) {
        return false;
    }

    public boolean hasAccountPermission(String pluginName, UUID accountID, UUID uuid, AccountPermission permission) {
        return false;
    }

    public boolean updateAccountPermission(String pluginName, UUID accountID, UUID uuid, AccountPermission permission, boolean value) {
        return false;
    }
}

