/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.settings;

import io.github.townyadvanced.config.CommentedConfiguration;
import io.github.townyadvanced.iconomy.settings.LangFile;
import io.github.townyadvanced.iconomy.util.FileMgmt;
import java.nio.file.Path;

public class LangStrings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;

    public static void loadLangFile(Path configPath) throws Exception {
        if (FileMgmt.checkOrCreateFile(configPath.toString())) {
            config = new CommentedConfiguration(configPath);
            if (!config.load()) {
                throw new Exception("Failed to load lang.yml!");
            }
            LangStrings.setDefaults(configPath);
            config.save();
        }
    }

    private static void setDefaults(Path configPath) {
        newConfig = new CommentedConfiguration(configPath);
        newConfig.load();
        for (LangFile root : LangFile.values()) {
            if (root.getComments().length > 0) {
                newConfig.addComment(root.getRoot(), root.getComments());
                continue;
            }
            LangStrings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), value.toString());
    }

    private static String getString(LangFile node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static String moneyPrefix() {
        return LangStrings.getString(LangFile.LANG_MONEY_PREFIX);
    }

    public static String personalBalance(String balance) {
        return String.format(LangStrings.getString(LangFile.LANG_PERSONAL_BALANCE), balance);
    }

    public static String personalRank(String rank) {
        return String.format(LangStrings.getString(LangFile.LANG_PERSONAL_RANK), rank);
    }

    public static String personalCredit(String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PERSONAL_CREDIT), amount);
    }

    public static String personalDebit(String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PERSONAL_DEBIT), amount);
    }

    public static String personalSet(String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PERSONAL_SET), amount);
    }

    public static String playerBalance(String name, String balance) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_BALANCE), name, balance);
    }

    public static String playerRank(String name, String rank) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_RANK), name, rank);
    }

    public static String playerDebit(String name, String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_DEBIT), name, amount);
    }

    public static String playerCredit(String name, String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_CREDIT), name, amount);
    }

    public static String playerSet(String name, String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_SET), name, amount);
    }

    public static String playerReset(String name) {
        return String.format(LangStrings.getString(LangFile.LANG_PLAYER_RESET), name);
    }

    public static String accountAlreadyExist() {
        return LangStrings.getString(LangFile.LANG_ERROR_ACCOUNT_ALREADY_EXISTS);
    }

    public static String noAccountFound(String name) {
        return String.format(LangStrings.getString(LangFile.LANG_ERROR_NO_ACCOUNT_FOUND), name);
    }

    public static String cannotSendSelf() {
        return LangStrings.getString(LangFile.LANG_PAYMENT_SELF);
    }

    public static String paymentTo(String amount, String name) {
        return String.format(LangStrings.getString(LangFile.LANG_PAYMENT_TO), amount, name);
    }

    public static String paymentFrom(String name, String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_PAYMENT_FROM), name, amount);
    }

    public static String notEnoughFunds() {
        return LangStrings.getString(LangFile.LANG_ERROR_CANNOT_AFFORD);
    }

    public static String accountCreated(String name) {
        return String.format(LangStrings.getString(LangFile.LANG_ACCOUNTS_CREATE), name);
    }

    public static String accountRemoved(String name) {
        return String.format(LangStrings.getString(LangFile.LANG_ACCOUNTS_REMOVED), name);
    }

    public static String accountsEmptied() {
        return LangStrings.getString(LangFile.LANG_ACCOUNTS_EMPTIED);
    }

    public static String accountsPurged() {
        return LangStrings.getString(LangFile.LANG_ACCOUNTS_PURGED);
    }

    public static String accountHiddenStatus(String status) {
        return String.format(LangStrings.getString(LangFile.LANG_ACCOUNTS_STATUS), status);
    }

    public static String statsHeader() {
        return LangStrings.getString(LangFile.LANG_STATS_HEADER);
    }

    public static String statsTotal(String curr, String total) {
        return String.format(LangStrings.getString(LangFile.LANG_STATS_TOTAL), curr, total);
    }

    public static String statsAverage(String curr, String avg) {
        return String.format(LangStrings.getString(LangFile.LANG_STATS_AVERAGE), curr, avg);
    }

    public static String statsAccounts(String num) {
        return String.format(LangStrings.getString(LangFile.LANG_STATS_ACCOUNTS), num);
    }

    public static String topHeader(String num) {
        return String.format(LangStrings.getString(LangFile.LANG_TOP_HEADER), num);
    }

    public static String topEmpty() {
        return LangStrings.getString(LangFile.LANG_TOP_EMPTY);
    }

    public static String topLine(String num, String name, String amount) {
        return String.format(LangStrings.getString(LangFile.LANG_TOP_LINE), num, name, amount);
    }
}

