/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.settings;

import io.github.townyadvanced.config.CommentedConfiguration;
import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.ConfigNodes;
import io.github.townyadvanced.iconomy.util.FileMgmt;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class Settings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;
    static DecimalFormat FORMAT;

    public static void loadConfig(Path configPath, String version) throws Exception {
        if (FileMgmt.checkOrCreateFile(configPath.toString())) {
            config = new CommentedConfiguration(configPath);
            if (!config.load()) {
                throw new Exception("Failed to load config.yml.");
            }
            Settings.setDefaults(iConomyUnlocked.getPlugin().getVersion(), configPath);
            config.save();
        }
    }

    public static void addComment(String root, String ... comments) {
        newConfig.addComment(root.toLowerCase(), comments);
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), value.toString());
    }

    private static void setProperty(String root, Object value) {
        config.set(root.toLowerCase(), value.toString());
    }

    private static void setDefaults(String version, Path configPath) {
        newConfig = new CommentedConfiguration(configPath);
        newConfig.load();
        for (ConfigNodes root : ConfigNodes.values()) {
            if (root.getComments().length > 0) {
                Settings.addComment(root.getRoot(), root.getComments());
            }
            if (root.getRoot() == ConfigNodes.VERSION.getRoot()) {
                Settings.setNewProperty(root.getRoot(), version);
                continue;
            }
            Settings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
        }
        config = newConfig;
        newConfig = null;
    }

    public static String getString(String root, String def) {
        String data = config.getString(root.toLowerCase(), def);
        if (data == null) {
            Settings.sendError(root.toLowerCase() + " from config.yml");
            return "";
        }
        return data;
    }

    private static void sendError(String msg) {
        iConomyUnlocked.getPlugin().getLogger().severe("Error could not read " + msg);
    }

    public static boolean getBoolean(ConfigNodes node) {
        return Boolean.parseBoolean(config.getString(node.getRoot().toLowerCase(), node.getDefault()));
    }

    public static double getDouble(ConfigNodes node) {
        try {
            return Double.parseDouble(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            Settings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes node) {
        try {
            return Integer.parseInt(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            Settings.sendError(node.getRoot().toLowerCase() + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static List<String> getStrArr(ConfigNodes node) {
        return Arrays.stream(Settings.getString(node).split(",")).collect(Collectors.toList());
    }

    public static String format(BigDecimal money) {
        return Settings.format(FORMAT.format(money.doubleValue()));
    }

    public static String format(double money) {
        return Settings.format(BigDecimal.valueOf(money));
    }

    private static String format(String money) {
        return String.format(Settings.getEconomyFormat(), money);
    }

    public static String format(UUID uuid, String name) {
        return Settings.format(iConomyUnlocked.getAccounts().get(uuid, name).getHoldings().balance());
    }

    public static String getCurrencyName() {
        return Settings.getString(ConfigNodes.CURRENCY_SETTINGS_NAME);
    }

    public static String getCurrencyNameSingular() {
        return Settings.getString(ConfigNodes.CURRENCY_SETTINGS_NAME_SINGULAR);
    }

    public static String getCurrencyNamePlural() {
        return Settings.getString(ConfigNodes.CURRENCY_SETTINGS_NAME_PLURAL);
    }

    public static String getEconomyFormat() {
        return Settings.getString(ConfigNodes.CURRENCY_SETTINGS_FORMAT);
    }

    public static int getVaultFractionalDigits() {
        return Settings.getInt(ConfigNodes.CURRENCY_SETTINGS_VAULT_FRACTIONAL_DIGITS);
    }

    public static double getDefaultBalance() {
        return Settings.getDouble(ConfigNodes.CURRENCY_SETTINGS_DEFAULT_BALANCE);
    }

    public static String getDBType() {
        return Settings.getString(ConfigNodes.DATABASE_TYPE);
    }

    public static String getDBName() {
        return Settings.getString(ConfigNodes.DATABASE_NAME);
    }

    public static String getDBTable() {
        return Settings.getString(ConfigNodes.DATABASE_TABLE);
    }

    public static String getMysqlUser() {
        return Settings.getString(ConfigNodes.DATABASE_MYSQL_USER);
    }

    public static String getMysqlPass() {
        return Settings.getString(ConfigNodes.DATABASE_MYSQL_PASS);
    }

    public static String getMysqlHostname() {
        return Settings.getString(ConfigNodes.DATABASE_MYSQL_HOSTNAME);
    }

    public static String getMysqlPort() {
        return Settings.getString(ConfigNodes.DATABASE_MYSQL_PORT);
    }

    public static String getMysqlFlags() {
        return Settings.getString(ConfigNodes.DATABASE_MYSQL_FLAGS);
    }

    public static boolean transactionLoggingEnabled() {
        return Settings.getBoolean(ConfigNodes.TRANSACTION_LOGGING_ENABLED);
    }

    public static List<String> getNonPlayerAccountPrefixes() {
        return Settings.getStrArr(ConfigNodes.ACCOUNT_SETTINGS_NON_PLAYER_ACCOUNT_NAME_PREFIXES);
    }

    public static boolean isNonPlayerAccountName(String name) {
        return Settings.getNonPlayerAccountPrefixes().stream().filter(prefix -> name.startsWith((String)prefix)).count() > 0L;
    }

    public static boolean hideNonPlayerAccountsInRankings() {
        return Settings.getBoolean(ConfigNodes.ACCOUNT_SETTINGS_HIDE_NON_PLAYER_ACCOUNTS_IN_RANKINGS);
    }

    static {
        FORMAT = new DecimalFormat("###,###,###.##");
    }
}

