/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.system;

import io.github.townyadvanced.iconomy.events.AccountRemoveEvent;
import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import io.github.townyadvanced.iconomy.system.Holdings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class Account {
    private UUID uuid;
    private String name;
    private String SQLTable = Settings.getDBTable();
    Logger log = iConomyUnlocked.getPlugin().getLogger();

    public Account(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public static Account getAccountOrThrow(UUID uuid) throws Exception {
        Account account = iConomyUnlocked.getAccounts().get(uuid);
        if (account == null) {
            throw new Exception(String.format("No account found using the UUID %s", uuid));
        }
        return account;
    }

    @Nullable
    public static Account getAccount(UUID uuid) {
        return iConomyUnlocked.getAccounts().get(uuid);
    }

    public static Account getAccountOrThrow(String name) throws Exception {
        Account account = iConomyUnlocked.getAccounts().get(name);
        if (account == null) {
            throw new Exception(String.format("No account found using the name %s", name));
        }
        return account;
    }

    @Nullable
    public static Account getAccount(String name) {
        return iConomyUnlocked.getAccounts().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        int id = -1;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, this.name);
            rs = ps.executeQuery();
            if (rs.next()) {
                id = rs.getInt("id");
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                id = -1;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return id;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Holdings getHoldings() {
        return new Holdings(this.uuid, this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHidden() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT hidden FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, this.name);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                boolean bool;
                boolean bl = bool = rs.getBoolean("hidden");
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return bl;
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to check status: " + String.valueOf(ex));
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHidden(boolean hidden) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("UPDATE " + this.SQLTable + " SET hidden = ? WHERE username = ?");
            ps.setBoolean(1, hidden);
            ps.setString(2, this.name);
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to update status: " + String.valueOf(ex));
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRank() {
        int i = 1;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE hidden = 0 " + (Settings.hideNonPlayerAccountsInRankings() ? "AND nonplayer = 0 " : "") + "ORDER BY balance DESC");
            rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString("username").equalsIgnoreCase(this.name)) {
                    int n = i;
                    iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                    return n;
                }
                ++i;
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
        finally {
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        AccountRemoveEvent event = new AccountRemoveEvent(this.name);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("DELETE FROM " + this.SQLTable + " WHERE uuid = ?");
            ps.setString(1, this.uuid.toString());
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to remove account: " + String.valueOf(ex));
                iConomyUnlocked.getBackEnd().close(conn, ps);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setName(String name) {
        this.name = name;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("UPDATE " + this.SQLTable + " SET username = ? WHERE uuid = ?");
            ps.setString(1, this.name);
            ps.setString(2, this.uuid.toString());
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to update status: " + String.valueOf(ex));
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNonPlayer() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT nonplayer FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, this.name);
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                boolean bool;
                boolean bl = bool = rs.getBoolean("nonplayer");
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return bl;
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to check status: " + String.valueOf(ex));
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNonPlayer(boolean b) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("UPDATE " + this.SQLTable + " SET nonplayer = ? WHERE uuid = ?");
            ps.setBoolean(1, b);
            ps.setString(2, this.uuid.toString());
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to update status: " + String.valueOf(ex));
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }
}

