/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.system;

import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import io.github.townyadvanced.iconomy.system.Account;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class Accounts {
    Logger log = iConomyUnlocked.getPlugin().getLogger();
    private String SQLTable = Settings.getDBTable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(UUID uuid) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean exists = false;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE uuid = ? LIMIT 1");
            ps.setString(1, uuid.toString());
            rs = ps.executeQuery();
            exists = rs.next();
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                exists = false;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean exists = false;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, name);
            rs = ps.executeQuery();
            exists = rs.next();
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                exists = false;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(UUID uuid, String name, boolean nonPlayer) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("INSERT INTO " + this.SQLTable + "(uuid, username, balance, hidden, nonplayer) VALUES (?, ?, ?, 0, ?)");
            ps.setString(1, uuid.toString());
            ps.setString(2, name);
            ps.setDouble(3, Settings.getDefaultBalance());
            ps.setBoolean(4, nonPlayer);
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importAccount(String uuidraw, String name, double balance, boolean hidden) {
        UUID uuid = UUID.fromString(uuidraw);
        if (uuid == null) {
            return false;
        }
        if (this.exists(uuid)) {
            Account account = Account.getAccount(uuid);
            account.setName(name);
            account.getHoldings().set(balance);
            account.setHidden(hidden);
            account.setNonPlayer(Settings.isNonPlayerAccountName(name));
            return true;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("INSERT INTO " + this.SQLTable + "(uuid, username, balance, hidden, nonplayer) VALUES (?, ?, ?, ?, ?)");
            ps.setString(1, uuid.toString());
            ps.setString(2, name);
            ps.setDouble(3, balance);
            ps.setBoolean(4, hidden);
            ps.setBoolean(5, Settings.isNonPlayerAccountName(name));
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(UUID uuid) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("DELETE FROM " + this.SQLTable + " WHERE uuid = ? LIMIT 1");
            ps.setString(1, uuid.toString());
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCompletely(String name) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("DELETE FROM " + this.SQLTable + " WHERE uuid = ? LIMIT 1");
            ps.setString(1, name);
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purge() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("DELETE FROM " + this.SQLTable + " WHERE balance = ?");
            ps.setDouble(1, Settings.getDefaultBalance());
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean emptyDatabase() {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("TRUNCATE TABLE " + this.SQLTable);
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                iConomyUnlocked.getBackEnd().close(conn, ps);
                return bl;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Double> values() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ArrayList<Double> Values2 = new ArrayList<Double>();
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT balance FROM " + this.SQLTable);
            rs = ps.executeQuery();
            while (rs.next()) {
                Values2.add(rs.getDouble("balance"));
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception e) {
            try {
                List<Double> list = null;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return list;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return Values2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Double> ranking(int amount) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        LinkedHashMap<String, Double> Ranking = new LinkedHashMap<String, Double>();
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT username,balance FROM " + this.SQLTable + " WHERE hidden = 0 " + (Settings.hideNonPlayerAccountsInRankings() ? "AND nonplayer = 0 " : "") + "ORDER BY balance DESC LIMIT ?");
            ps.setInt(1, amount);
            rs = ps.executeQuery();
            while (rs.next()) {
                Ranking.put(rs.getString("username"), rs.getDouble("balance"));
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception e) {
            try {
                this.log.warning(e.getMessage());
                LinkedHashMap<String, Double> linkedHashMap = null;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return linkedHashMap;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return Ranking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, String> getUUIDNameMap() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ConcurrentHashMap<UUID, String> map = new ConcurrentHashMap<UUID, String>();
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT uuid,username FROM " + this.SQLTable);
            rs = ps.executeQuery();
            while (rs.next()) {
                map.put(UUID.fromString(rs.getString("uuid")), rs.getString("username"));
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception e) {
            try {
                this.log.warning(e.getMessage());
                Map<UUID, String> map2 = null;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return map2;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return map;
    }

    public Account get(UUID uuid, String name) {
        return this.get(uuid, name, false);
    }

    public Account get(UUID uuid, String name, boolean playerJoinEvent) {
        if (this.exists(uuid)) {
            if (!playerJoinEvent) {
                return new Account(uuid, name);
            }
            Account account = Account.getAccount(uuid);
            String oldName = account.getName();
            if (!oldName.equals(name)) {
                account.setName(name);
                iConomyUnlocked.getPlugin().getLogger().info(String.format("iConomyUnlocked has found a player with UUID %s has changed their name from %s to %s.", uuid.toString(), oldName, name));
                iConomyUnlocked.getPlugin().getLogger().info("iConomyUnlocked's database will be altered to reflect this change.");
            }
            return account;
        }
        if (!this.create(uuid, name, Settings.isNonPlayerAccountName(name))) {
            return null;
        }
        return new Account(uuid, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Account get(String name) {
        UUID uuid;
        int id = 0;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean exists = false;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, name);
            rs = ps.executeQuery();
            exists = rs.next();
            if (exists) {
                id = rs.getInt("id");
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                exists = false;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        if (exists && (uuid = this.getUUID(id)) != null) {
            return this.get(uuid, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Account get(UUID uuid) {
        String name;
        int id = 0;
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        boolean exists = false;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE uuid = ? LIMIT 1");
            ps.setString(1, uuid.toString());
            rs = ps.executeQuery();
            exists = rs.next();
            if (exists) {
                id = rs.getInt("id");
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                exists = false;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        if (exists && !(name = this.getName(id)).isEmpty()) {
            return this.get(uuid, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID getUUID(int id) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        UUID uuid = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE id = ? LIMIT 1");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                uuid = UUID.fromString(rs.getString("uuid"));
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                UUID uUID = null;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return uUID;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getName(int id) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        String name = "";
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE id = ? LIMIT 1");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                name = rs.getString("username");
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                String string = null;
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                return string;
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return name;
    }

    public void updateAccountsForNewTables(List<String> tablesUpdated) {
        if (tablesUpdated.contains("nonplayer")) {
            for (String name : new ArrayList<String>(this.getUUIDNameMap().values())) {
                if (!Settings.isNonPlayerAccountName(name)) continue;
                this.log.info("Account " + name + " is being marked as a non player account.");
                this.get(name).setNonPlayer(true);
            }
        }
    }
}

