/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.system;

import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import java.io.File;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.h2.jdbcx.JdbcConnectionPool;

public class BackEnd {
    private static final String plugin_dir = iConomyUnlocked.getPlugin().getDataFolder().getPath();
    private JdbcConnectionPool h2pool;
    private String SQLTable = Settings.getDBTable();
    private String dsn;
    private String username;
    private String password;
    private Logger log = iConomyUnlocked.getPlugin().getLogger();

    public BackEnd() throws Exception {
        validDBTypes type = validDBTypes.valueOf(Settings.getDBType());
        switch (type.ordinal()) {
            case 0: {
                this.dsn = "jdbc:h2:./" + plugin_dir + File.separator + Settings.getDBName() + ";AUTO_RECONNECT=TRUE";
                this.username = "sa";
                this.password = "sa";
                if (this.h2pool != null) break;
                this.h2pool = JdbcConnectionPool.create((String)this.dsn, (String)this.username, (String)this.password);
                break;
            }
            case 1: {
                this.dsn = "jdbc:mysql://" + Settings.getMysqlHostname() + ":" + Settings.getMysqlPort() + "/" + Settings.getDBName() + Settings.getMysqlFlags();
                this.username = Settings.getMysqlUser();
                this.password = Settings.getMysqlPass();
                break;
            }
            default: {
                throw new Exception("Unknown DB type set in config.yml: " + Settings.getDBType() + ", no DB connection was established!");
            }
        }
    }

    public void setupAccountTable() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        validDBTypes type = validDBTypes.valueOf(Settings.getDBType());
        switch (type.ordinal()) {
            case 0: {
                try {
                    ps = conn.prepareStatement("CREATE TABLE " + this.SQLTable + "(id INT auto_increment PRIMARY KEY,uuid VARCHAR(36) UNIQUE,username VARCHAR(32),balance DECIMAL (64, 2),hidden BOOLEAN DEFAULT '0',nonplayer BOOLEAN DEFAULT '0');");
                    ps.executeUpdate();
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 1: {
                DatabaseMetaData dbm = conn.getMetaData();
                rs = dbm.getTables(null, null, this.SQLTable, null);
                if (rs.next()) break;
                this.log.info("Creating table: " + this.SQLTable);
                ps = conn.prepareStatement("CREATE TABLE " + this.SQLTable + " (`id` INT(10) NOT NULL AUTO_INCREMENT,`uuid` VARCHAR(36) NOT NULL,`username` VARCHAR(32) NOT NULL,`balance` DECIMAL(64, 2) NOT NULL,`hidden` BOOLEAN NOT NULL DEFAULT '0',`nonplayer` BOOLEAN NOT NULL DEFAULT '0',PRIMARY KEY (`id`),UNIQUE(`uuid`))");
                if (ps == null) break;
                ps.executeUpdate();
                this.log.info("Table Created.");
                break;
            }
        }
        this.close(conn, ps, rs);
    }

    public void setupTransactionTable() throws Exception {
        if (!Settings.transactionLoggingEnabled()) {
            return;
        }
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        validDBTypes type = validDBTypes.valueOf(Settings.getDBType());
        switch (type.ordinal()) {
            case 0: {
                try {
                    ps = conn.prepareStatement("CREATE TABLE " + this.SQLTable + "_Transactions(id INT AUTO_INCREMENT PRIMARY KEY, account_from TEXT, account_to TEXT, account_from_balance DECIMAL(64, 2), account_to_balance DECIMAL(64, 2), timestamp TEXT, set DECIMAL(64, 2), gain DECIMAL(64, 2), loss DECIMAL(64, 2));");
                    ps.executeUpdate();
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 1: {
                DatabaseMetaData dbm = conn.getMetaData();
                rs = dbm.getTables(null, null, this.SQLTable + "_Transactions", null);
                if (rs.next()) break;
                this.log.info("Creating logging database.. [" + this.SQLTable + "_Transactions]");
                ps = conn.prepareStatement("CREATE TABLE " + this.SQLTable + "_Transactions (`id` INT(255) NOT NULL AUTO_INCREMENT, `account_from` TEXT NOT NULL, `account_to` TEXT NOT NULL, `account_from_balance` DECIMAL(65, 2) NOT NULL, `account_to_balance` DECIMAL(65, 2) NOT NULL, `timestamp` TEXT NOT NULL, `set` DECIMAL(65, 2) NOT NULL, `gain` DECIMAL(65, 2) NOT NULL, `loss` DECIMAL(65, 2) NOT NULL, PRIMARY KEY (`id`));");
                if (ps == null) break;
                ps.executeUpdate();
                this.log.info("Logging Table Created.");
                break;
            }
            default: {
                throw new Exception("Unknown DB type set in config.yml: " + Settings.getDBType() + ", log unable to start!");
            }
        }
        this.log.info("Logging enabled.");
        this.close(conn, ps, rs);
    }

    public JdbcConnectionPool connectionPool() {
        return this.h2pool;
    }

    Connection getConnection() {
        try {
            validDBTypes type = validDBTypes.valueOf(Settings.getDBType());
            switch (type.ordinal()) {
                case 0: {
                    return this.h2pool.getConnection();
                }
                case 1: {
                    if (this.username.equalsIgnoreCase("") && this.password.equalsIgnoreCase("")) {
                        return DriverManager.getConnection(this.dsn);
                    }
                    return DriverManager.getConnection(this.dsn, this.username, this.password);
                }
            }
            this.log.severe("Could not create connection!");
        }
        catch (SQLException e) {
            this.log.severe("Could not create connection: " + String.valueOf(e));
        }
        return null;
    }

    void close(Connection conn, PreparedStatement ps, ResultSet rs) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void close(Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateTables() {
        Connection conn = this.getConnection();
        LinkedList<CallSite> MySQL = new LinkedList<CallSite>();
        LinkedList<CallSite> H2 = new LinkedList<CallSite>();
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<String> updates = new ArrayList<String>();
        boolean usingMysql = Settings.getDBType().equalsIgnoreCase("mysql");
        String tableName = usingMysql ? this.SQLTable : this.SQLTable.toUpperCase(Locale.ROOT);
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            ResultSet columns = metadata.getColumns(null, null, tableName, "NONPLAYER");
            if (!columns.next()) {
                MySQL.add((CallSite)((Object)("ALTER TABLE " + tableName + " ADD nonplayer boolean DEFAULT '0';")));
                H2.add((CallSite)((Object)("ALTER TABLE " + tableName + " ADD NONPLAYER BOOLEAN DEFAULT '0';")));
                updates.add("nonplayer");
            }
            if (MySQL.isEmpty() && H2.isEmpty()) {
                this.log.info("   No database updates needed.");
                ArrayList<String> arrayList = updates;
                return arrayList;
            }
            LinkedList<CallSite> statements = usingMysql ? MySQL : H2;
            int i = 1;
            for (String string : statements) {
                stmt = conn.createStatement();
                this.log.info("   Executing SQL Query #" + i + " of " + statements.size() + ": " + string);
                stmt.execute(string);
                this.log.info("   Statement Executed.");
                ++i;
            }
        }
        catch (SQLException ex) {
            this.log.warning("   Error updating database: " + ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            this.close(conn);
        }
        return updates;
    }

    private static enum validDBTypes {
        H2,
        MYSQL;

    }
}

