/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.system;

import io.github.townyadvanced.iconomy.events.AccountResetEvent;
import io.github.townyadvanced.iconomy.events.AccountSetEvent;
import io.github.townyadvanced.iconomy.events.AccountUpdateEvent;
import io.github.townyadvanced.iconomy.iConomyUnlocked;
import io.github.townyadvanced.iconomy.settings.Settings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class Holdings {
    private UUID uuid;
    private String name = "";
    private Double balance = null;
    Logger log = iConomyUnlocked.getPlugin().getLogger();
    private String SQLTable = Settings.getDBTable();

    public Holdings(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public double balance() {
        if (this.balance == null) {
            this.balance = this.get();
        }
        return this.balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized double get() {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        double balance = Settings.getDefaultBalance();
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + this.SQLTable + " WHERE username = ? LIMIT 1");
            ps.setString(1, this.name);
            rs = ps.executeQuery();
            if (rs.next()) {
                balance = rs.getDouble("balance");
            }
            iConomyUnlocked.getBackEnd().close(conn, ps, rs);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to grab holdings: " + String.valueOf(ex));
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps, rs);
                throw throwable;
            }
        }
        return balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(double balance) {
        this.balance = balance;
        Bukkit.getPluginManager().callEvent((Event)new AccountSetEvent(this, balance));
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = iConomyUnlocked.getBackEnd().getConnection();
            ps = conn.prepareStatement("UPDATE " + this.SQLTable + " SET balance = ? WHERE username = ?");
            ps.setDouble(1, balance);
            ps.setString(2, this.name);
            ps.executeUpdate();
            iConomyUnlocked.getBackEnd().close(conn, ps);
        }
        catch (Exception ex) {
            try {
                this.log.warning("Failed to set holdings: " + String.valueOf(ex));
                iConomyUnlocked.getBackEnd().close(conn, ps);
            }
            catch (Throwable throwable) {
                iConomyUnlocked.getBackEnd().close(conn, ps);
                throw throwable;
            }
        }
    }

    public synchronized void add(double amount) {
        double balance = this.balance();
        double ending = balance + amount;
        this.callEventAndSetHoldings(amount, balance, ending);
    }

    public synchronized void subtract(double amount) {
        double balance = this.balance();
        double ending = balance - amount;
        this.callEventAndSetHoldings(amount, balance, ending);
    }

    public synchronized void divide(double amount) {
        double balance = this.balance();
        double ending = balance / amount;
        this.callEventAndSetHoldings(amount, balance, ending);
    }

    public synchronized void multiply(double amount) {
        double balance = this.balance();
        double ending = balance * amount;
        this.callEventAndSetHoldings(amount, balance, ending);
    }

    public void reset() {
        Bukkit.getPluginManager().callEvent((Event)new AccountResetEvent(this));
        this.set(Settings.getDefaultBalance());
    }

    private void callEventAndSetHoldings(double amount, double previousBalance, double newBalance) {
        Bukkit.getPluginManager().callEvent((Event)new AccountUpdateEvent(this, previousBalance, newBalance, amount));
        this.set(newBalance);
    }

    public boolean isNegative() {
        return this.get() < 0.0;
    }

    public boolean hasEnough(double amount) {
        return amount <= this.get();
    }

    public boolean hasOver(double amount) {
        return amount < this.get();
    }

    public boolean hasUnder(double amount) {
        return amount > this.get();
    }

    public String toString() {
        return String.format(Settings.getEconomyFormat(), this.get());
    }
}

