/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.iconomy.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileMgmt {
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock writeLock = readWriteLock.writeLock();

    public static boolean checkOrCreateFile(String filePath) {
        File file = new File(filePath);
        if (!FileMgmt.checkOrCreateFolder(file.getParentFile().getPath())) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return FileMgmt.newFile(file);
    }

    private static boolean checkOrCreateFolder(String folderPath) {
        File file = new File(folderPath);
        if (file.exists() || file.isDirectory()) {
            return true;
        }
        return FileMgmt.newDir(file);
    }

    private static boolean newDir(File dir) {
        try {
            writeLock.lock();
            boolean bl = dir.mkdirs();
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private static boolean newFile(File file) {
        try {
            writeLock.lock();
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }
}

