package com.nerjal.status_hider.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.IpWhitelist;
import com.nerjal.status_hider.PlayerIpCache;
import com.nerjal.status_hider.RequestMetrics;
import net.minecraft.class_3176;
import net.minecraft.server.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;

@Mixin(Main.class)
public abstract class MainMixin {
    @Inject(method = "main", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/dedicated/ServerPropertiesLoader;<init>(Ljava/nio/file/Path;)V"))
    private static void mainInitIpCache(
            String[] args, CallbackInfo ci, @Share("ipCache") LocalRef<PlayerIpCache> ref,
            @Share("reqMetrics") LocalRef<RequestMetrics> ref2, @Share("ipWhitelist") LocalRef<IpWhitelist> ref3,
            @Share("ipLimitList") LocalRef<IpWhitelist> ref4
    ) {
        ref.set(PlayerIpCache.loadOrCreate(Path.of("player_ip_cache")));
        ref2.set(RequestMetrics.loadOrCreate(Path.of("request_metrics")));
        ref3.set(IpWhitelist.loadOrCreate(Path.of("ip_whitelist")));
        ref4.set(IpWhitelist.loadOrCreate(Path.of("ip_limit_list")));
    }

    @Inject(
            method = "main",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/Main$1;<init>(Ljava/lang/String;Lnet/minecraft/server/dedicated/MinecraftDedicatedServer;)V"
            )
    )
    private static void mainServerStartIpCache(
            String[] args, CallbackInfo ci, @Local class_3176 server,
            @Share("ipCache") LocalRef<PlayerIpCache> ref, @Share("reqMetrics") LocalRef<RequestMetrics> ref2,
            @Share("ipWhitelist") LocalRef<IpWhitelist> ref3, @Share("ipLimitList") LocalRef<IpWhitelist> ref4
    ) {
        ((IpCacheHolder)server).setPlayerIpCache(ref.get());
        ((IpCacheHolder)server).setRequestMetrics(ref2.get());
        ((IpCacheHolder)server).setIpWhitelist(ref3.get());
        ((IpCacheHolder)server).setIpLimitList(ref4.get());
    }
}
