package com.nerjal.status_hider.mixin;

import com.nerjal.status_hider.IpCacheHolder;
import com.nerjal.status_hider.StatusHider;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {
    @Shadow @Final private MinecraftServer server;

    @Inject(method = "onPlayerConnect", at = @At("TAIL"))
    private void onPlayerConnectCacheIp(
            class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci
    ) {
        String s = connection.method_52909(true);
        if (!s.equals("local")) {
            s = StatusHider.cleanIp(s);
            ((IpCacheHolder) this.server).getPlayerIpCache().registerPlayer(s.hashCode(), player);
        }
    }
}
